/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.Messages;
import com.cloudbees.plugins.credentials.domains.Domain;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.BulkChange;
import hudson.ExtensionList;
import hudson.Functions;
import hudson.Util;
import hudson.model.Actionable;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.model.Saveable;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.AccessDeniedException3;
import hudson.security.Permission;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.springframework.security.core.Authentication;

public abstract class CredentialsStore
implements AccessControlled,
Saveable {
    private final Class<? extends CredentialsProvider> providerClass;
    private transient Boolean domainsModifiable;

    public CredentialsStore(Class<? extends CredentialsProvider> providerClass) {
        this.providerClass = providerClass;
    }

    public CredentialsStore() {
        Class<?> clazz;
        for (clazz = this.getClass().getEnclosingClass(); clazz != null && !CredentialsProvider.class.isAssignableFrom(clazz); clazz = clazz.getEnclosingClass()) {
        }
        if (clazz == null) {
            throw new AssertionError((Object)(this.getClass() + " doesn't have an outer class. Use the constructor that takes the Class object explicitly."));
        }
        if (!CredentialsProvider.class.isAssignableFrom(clazz)) {
            throw new AssertionError((Object)(this.getClass() + " doesn't have an outer class implementing CredentialsProvider. Use the constructor that takes the Class object explicitly"));
        }
        this.providerClass = clazz;
    }

    @NonNull
    public final CredentialsProvider getProviderOrDie() {
        CredentialsProvider provider = this.getProvider();
        if (provider == null) {
            throw new IllegalStateException("The credentials provider " + this.providerClass + " has been removed from the list of active extension points");
        }
        return provider;
    }

    @Nullable
    public final CredentialsProvider getProvider() {
        return (CredentialsProvider)((Object)ExtensionList.lookup(CredentialsProvider.class).get(this.providerClass));
    }

    @Nullable
    public final Set<CredentialsScope> getScopes() {
        CredentialsProvider provider = this.getProvider();
        return provider == null ? null : provider.getScopes(this.getContext());
    }

    @NonNull
    public abstract ModelObject getContext();

    @Deprecated
    public boolean hasPermission(@NonNull org.acegisecurity.Authentication a, @NonNull Permission permission) {
        return this.hasPermission2(a.toSpring(), permission);
    }

    public boolean hasPermission2(@NonNull Authentication a, @NonNull Permission permission) {
        if (Util.isOverridden(CredentialsStore.class, this.getClass(), (String)"hasPermission", (Class[])new Class[]{org.acegisecurity.Authentication.class, Permission.class})) {
            return this.hasPermission(org.acegisecurity.Authentication.fromSpring((Authentication)a), permission);
        }
        throw new AbstractMethodError("Implement hasPermission2 from " + this.getClass());
    }

    @NonNull
    public ACL getACL() {
        return new ACL(){

            public boolean hasPermission2(@NonNull Authentication a, @NonNull Permission permission) {
                return CredentialsStore.this.hasPermission2(a, permission);
            }
        };
    }

    public final void checkPermission(@NonNull Permission p) {
        Authentication a = Jenkins.getAuthentication2();
        if (!this.hasPermission2(a, p)) {
            throw new AccessDeniedException3(a, p);
        }
    }

    public final boolean hasPermission(@NonNull Permission p) {
        return this.hasPermission2(Jenkins.getAuthentication2(), p);
    }

    @NonNull
    public List<Domain> getDomains() {
        return Collections.singletonList(Domain.global());
    }

    @CheckForNull
    public Domain getDomainByName(@CheckForNull String name) {
        return this.getDomains().stream().filter(d -> StringUtils.equals((String)name, (String)d.getName())).findFirst().orElse(null);
    }

    public final boolean isDomainsModifiable() {
        if (this.domainsModifiable == null) {
            try {
                this.domainsModifiable = this.isOverridden("getDomains", new Class[0]) && this.isOverridden("addDomain", Domain.class, List.class) && this.isOverridden("removeDomain", Domain.class) && this.isOverridden("updateDomain", Domain.class, Domain.class);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
        return this.domainsModifiable;
    }

    private boolean isOverridden(String name, Class ... args) throws NoSuchMethodException {
        return this.getClass().getMethod(name, args).getDeclaringClass() != CredentialsStore.class;
    }

    @NonNull
    public abstract List<Credentials> getCredentials(@NonNull Domain var1);

    public final boolean addDomain(@NonNull Domain domain, Credentials ... credentials) throws IOException {
        return this.addDomain(domain, Arrays.asList(credentials));
    }

    public boolean addDomain(@NonNull Domain domain, List<Credentials> credentials) throws IOException {
        throw new UnsupportedOperationException("Implementation does not support adding domains");
    }

    public boolean removeDomain(@NonNull Domain domain) throws IOException {
        throw new UnsupportedOperationException("Implementation does not support removing domains");
    }

    public boolean updateDomain(@NonNull Domain current, @NonNull Domain replacement) throws IOException {
        throw new UnsupportedOperationException("Implementation does not support updating domains");
    }

    public abstract boolean addCredentials(@NonNull Domain var1, @NonNull Credentials var2) throws IOException;

    public abstract boolean removeCredentials(@NonNull Domain var1, @NonNull Credentials var2) throws IOException;

    public abstract boolean updateCredentials(@NonNull Domain var1, @NonNull Credentials var2, @NonNull Credentials var3) throws IOException;

    public final boolean isApplicable(Descriptor<?> descriptor) {
        boolean allFiltersMatch = DescriptorVisibilityFilter.all().stream().allMatch(filter -> filter.filter((Object)this, descriptor));
        if (!allFiltersMatch) {
            return false;
        }
        CredentialsProvider provider = this.getProvider();
        return this._isApplicable(descriptor) && (provider == null || provider.isApplicable(descriptor));
    }

    protected boolean _isApplicable(Descriptor<?> descriptor) {
        return true;
    }

    public final List<CredentialsDescriptor> getCredentialsDescriptors() {
        CredentialsProvider provider = this.getProvider();
        List result = DescriptorVisibilityFilter.apply((Object)this, (Iterable)ExtensionList.lookup(CredentialsDescriptor.class));
        if (provider != null && provider.isEnabled()) {
            result = result.stream().filter(d -> this._isApplicable((Descriptor<?>)d) && provider._isApplicable((Descriptor<?>)d) && d.isApplicable(provider)).collect(Collectors.toList());
        }
        return result;
    }

    @CheckForNull
    public String getRelativeLinkToContext() {
        ModelObject context = this.getContext();
        if (context instanceof Item) {
            return Functions.getRelativeLinkTo((Item)((Item)context));
        }
        StaplerRequest request = Stapler.getCurrentRequest();
        if (request == null) {
            return null;
        }
        if (context instanceof Jenkins) {
            String suffix = Jenkins.get().hasPermission(Jenkins.ADMINISTER) ? "/manage/" : "/";
            return URI.create(request.getContextPath() + suffix).normalize().toString();
        }
        if (context instanceof User) {
            return URI.create(request.getContextPath() + "/" + ((User)context).getUrl() + "/").normalize().toString();
        }
        return null;
    }

    @CheckForNull
    public String getRelativeLinkToAction() {
        List actions;
        ModelObject context = this.getContext();
        String relativeLink = this.getRelativeLinkToContext();
        if (relativeLink == null) {
            return null;
        }
        CredentialsStoreAction a = this.getStoreAction();
        if (a != null) {
            return relativeLink + "credentials/store/" + a.getUrlName() + "/";
        }
        if (context instanceof Actionable) {
            actions = ((Actionable)context).getActions(CredentialsStoreAction.class);
        } else if (context instanceof Jenkins) {
            actions = Util.filter((List)((Jenkins)context).getActions(), CredentialsStoreAction.class);
        } else if (context instanceof User) {
            actions = Util.filter((List)((User)context).getTransientActions(), CredentialsStoreAction.class);
        } else {
            return null;
        }
        for (CredentialsStoreAction action : actions) {
            if (action.getStore() != this) continue;
            return relativeLink + action.getUrlName() + "/";
        }
        return null;
    }

    @CheckForNull
    public String getRelativeLinkTo(Domain domain) {
        String relativeLink = this.getRelativeLinkToAction();
        if (relativeLink == null) {
            return null;
        }
        return relativeLink + domain.getUrl();
    }

    public final String getContextDisplayName() {
        ModelObject context = this.getContext();
        if (context instanceof Item) {
            return ((Item)context).getFullDisplayName();
        }
        if (context instanceof Jenkins) {
            return context.getDisplayName();
        }
        if (context instanceof ItemGroup) {
            return ((ItemGroup)context).getFullDisplayName();
        }
        if (context instanceof User) {
            return Messages.CredentialsStoreAction_UserDisplayName(context.getDisplayName());
        }
        return context.getDisplayName();
    }

    public String getDisplayName() {
        Class<?> c = this.getClass();
        while (c.getEnclosingClass() != null) {
            c = c.getEnclosingClass();
        }
        String name = c.getSimpleName().replaceAll("(?i)(Impl|Credentials|Provider|Store)+", "");
        if (StringUtils.isBlank((String)name)) {
            name = c.getSimpleName();
        }
        return StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)name), (char)' ');
    }

    @Nullable
    public CredentialsStoreAction getStoreAction() {
        return null;
    }

    public void save() throws IOException {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        if (this.getContext() instanceof Saveable) {
            ((Saveable)this.getContext()).save();
        }
    }
}

