/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.object;

import java.util.HashMap;
import java.util.Map;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.MorpherRegistry;
import net.sf.ezmorph.ObjectMorpher;
import net.sf.ezmorph.object.NumberMorpher;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class SwitchingMorpher
implements ObjectMorpher {
    private Map classMap = new HashMap();
    private MorpherRegistry morpherRegistry;

    public SwitchingMorpher(Map classMap, MorpherRegistry morpherRegistry) {
        this.morpherRegistry = morpherRegistry;
        if (classMap == null || classMap.isEmpty()) {
            throw new MorphException("Must specify at least one mapping");
        }
        this.classMap.putAll(classMap);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumberMorpher)) {
            return false;
        }
        SwitchingMorpher other = (SwitchingMorpher)obj;
        if (this.classMap.size() != other.classMap.size()) {
            return false;
        }
        for (Map.Entry entry : this.classMap.entrySet()) {
            if (!other.classMap.containsKey(entry.getKey())) {
                return false;
            }
            if (entry.getValue().equals(other.classMap.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        for (Map.Entry entry : this.classMap.entrySet()) {
            builder.append(entry.getKey());
            builder.append(entry.getValue());
        }
        return builder.toHashCode();
    }

    @Override
    public Object morph(Object value) {
        if (value == null) {
            return null;
        }
        Class target = (Class)this.classMap.get(value.getClass());
        return this.morpherRegistry.morph(target, value);
    }

    @Override
    public Class morphsTo() {
        return Object.class;
    }

    @Override
    public boolean supports(Class clazz) {
        return true;
    }
}

