/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import hudson.model.AbstractProject;
import hudson.security.ACL;
import hudson.security.ACLContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class DependencyRunner
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(DependencyRunner.class.getName());
    ProjectRunnable runnable;
    List<AbstractProject> polledProjects = new ArrayList<AbstractProject>();

    public DependencyRunner(ProjectRunnable runnable) {
        this.runnable = runnable;
    }

    @Override
    public void run() {
        try (ACLContext ctx = ACL.as2(ACL.SYSTEM2);){
            HashSet<AbstractProject> topLevelProjects = new HashSet<AbstractProject>();
            LOGGER.fine("assembling top level projects");
            for (AbstractProject p : Jenkins.get().allItems(AbstractProject.class)) {
                if (p.getUpstreamProjects().size() == 0) {
                    LOGGER.fine("adding top level project " + p.getName());
                    topLevelProjects.add(p);
                    continue;
                }
                LOGGER.fine("skipping project since not a top level project: " + p.getName());
            }
            this.populate(topLevelProjects);
            for (AbstractProject p : this.polledProjects) {
                LOGGER.fine("running project in correct dependency order: " + p.getName());
                this.runnable.run(p);
            }
        }
    }

    private void populate(Collection<? extends AbstractProject> projectList) {
        for (AbstractProject abstractProject : projectList) {
            if (this.polledProjects.contains(abstractProject)) {
                LOGGER.fine("removing project " + abstractProject.getName() + " for re-add");
                this.polledProjects.remove(abstractProject);
            }
            LOGGER.fine("adding project " + abstractProject.getName());
            this.polledProjects.add(abstractProject);
            this.populate(abstractProject.getDownstreamProjects());
        }
    }

    public static interface ProjectRunnable {
        public void run(AbstractProject var1);
    }
}

