/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import com.thoughtworks.xstream.XStream;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.BulkChange;
import hudson.Extension;
import hudson.Messages;
import hudson.URLConnectionDecorator;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import hudson.util.DaemonThreadFactory;
import hudson.util.FormValidation;
import hudson.util.NamingThreadFactory;
import hudson.util.Scrambler;
import hudson.util.Secret;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import jenkins.UserAgentURLConnectionDecorator;
import jenkins.model.Jenkins;
import jenkins.security.stapler.StaplerAccessibleType;
import jenkins.util.JenkinsJVM;
import jenkins.util.SystemProperties;
import org.jenkinsci.Symbol;
import org.jvnet.robust_http_client.RetryableHttpStream;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

@StaplerAccessibleType
public final class ProxyConfiguration
extends AbstractDescribableImpl<ProxyConfiguration>
implements Saveable,
Serializable {
    private static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = SystemProperties.getInteger("hudson.ProxyConfiguration.DEFAULT_CONNECT_TIMEOUT_MILLIS", (int)TimeUnit.SECONDS.toMillis(20L));
    public final String name;
    public final int port;
    private String userName;
    @Restricted(value={NoExternalUse.class})
    public String noProxyHost;
    @Deprecated
    private String password;
    private Secret secretPassword;
    private String testUrl;
    private transient Authenticator authenticator;
    private transient boolean authCacheSeeded;
    private static final Executor httpClientExecutor = Executors.newCachedThreadPool(new NamingThreadFactory(new DaemonThreadFactory(), "Jenkins HttpClient"));
    private static final XStream XSTREAM = new XStream2();
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public ProxyConfiguration(String name, int port) {
        this(name, port, null, null);
    }

    public ProxyConfiguration(String name, int port, String userName, String password) {
        this(name, port, userName, password, null);
    }

    public ProxyConfiguration(String name, int port, String userName, String password, String noProxyHost) {
        this(name, port, userName, password, noProxyHost, null);
    }

    public ProxyConfiguration(String name, int port, String userName, String password, String noProxyHost, String testUrl) {
        this.name = Util.fixEmptyAndTrim(name);
        this.port = port;
        this.userName = Util.fixEmptyAndTrim(userName);
        String tempPassword = Util.fixEmptyAndTrim(password);
        this.secretPassword = tempPassword != null ? Secret.fromString(tempPassword) : null;
        this.noProxyHost = Util.fixEmptyAndTrim(noProxyHost);
        this.testUrl = Util.fixEmptyAndTrim(testUrl);
        this.authenticator = this.newAuthenticator();
    }

    private Authenticator newAuthenticator() {
        return new Authenticator(){

            @Override
            public PasswordAuthentication getPasswordAuthentication() {
                String userName = ProxyConfiguration.this.getUserName();
                if (this.getRequestorType() == Authenticator.RequestorType.PROXY && userName != null) {
                    return new PasswordAuthentication(userName, Secret.toString(ProxyConfiguration.this.secretPassword).toCharArray());
                }
                return null;
            }
        };
    }

    public String getUserName() {
        return this.userName;
    }

    public Secret getSecretPassword() {
        return this.secretPassword;
    }

    @Deprecated
    public String getPassword() {
        return Secret.toString(this.secretPassword);
    }

    @Deprecated
    public String getEncryptedPassword() {
        return this.secretPassword == null ? null : this.secretPassword.getEncryptedValue();
    }

    public String getTestUrl() {
        return this.testUrl;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    public List<Pattern> getNoProxyHostPatterns() {
        return ProxyConfiguration.getNoProxyHostPatterns(this.noProxyHost);
    }

    public String getNoProxyHost() {
        return this.noProxyHost;
    }

    public static List<Pattern> getNoProxyHostPatterns(String noProxyHost) {
        if (noProxyHost == null) {
            return Collections.emptyList();
        }
        ArrayList<Pattern> r = new ArrayList<Pattern>();
        for (String s : noProxyHost.split("[ \t\n,|]+")) {
            if (s.isEmpty()) continue;
            r.add(Pattern.compile(s.replace(".", "\\.").replace("*", ".*")));
        }
        return r;
    }

    private static boolean isExcluded(String needle, String haystack) {
        return ProxyConfiguration.getNoProxyHostPatterns(haystack).stream().anyMatch(p -> p.matcher(needle).matches());
    }

    @DataBoundSetter
    public void setSecretPassword(Secret secretPassword) {
        this.secretPassword = secretPassword;
    }

    @DataBoundSetter
    public void setTestUrl(String testUrl) {
        this.testUrl = testUrl;
    }

    @DataBoundSetter
    public void setUserName(String userName) {
        this.userName = Util.fixEmptyAndTrim(userName);
    }

    @DataBoundSetter
    public void setNoProxyHost(String noProxyHost) {
        this.noProxyHost = noProxyHost;
    }

    @Deprecated
    public Proxy createProxy() {
        return this.createProxy(null);
    }

    public Proxy createProxy(String host) {
        return ProxyConfiguration.createProxy(host, this.name, this.port, this.noProxyHost);
    }

    public static Proxy createProxy(String host, String name, int port, String noProxyHost) {
        if (host != null && noProxyHost != null && ProxyConfiguration.isExcluded(host, noProxyHost)) {
            return Proxy.NO_PROXY;
        }
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(name, port));
    }

    @Override
    public void save() throws IOException {
        if (BulkChange.contains(this)) {
            return;
        }
        XmlFile config = ProxyConfiguration.getXmlFile();
        config.write(this);
        SaveableListener.fireOnChange(this, config);
    }

    private Object readResolve() {
        if (this.secretPassword == null) {
            this.secretPassword = Secret.fromString(Scrambler.descramble(this.password));
        }
        this.password = null;
        this.authenticator = this.newAuthenticator();
        this.userName = Util.fixEmptyAndTrim(this.userName);
        return this;
    }

    public static XmlFile getXmlFile() {
        return new XmlFile(XSTREAM, new File(Jenkins.get().getRootDir(), "proxy.xml"));
    }

    public static ProxyConfiguration load() throws IOException {
        XmlFile f = ProxyConfiguration.getXmlFile();
        if (f.exists()) {
            return (ProxyConfiguration)f.read();
        }
        return null;
    }

    @Deprecated
    public static URLConnection open(URL url) throws IOException {
        URLConnection con;
        ProxyConfiguration p = ProxyConfiguration.get();
        if (p == null) {
            con = url.openConnection();
        } else {
            Proxy proxy = p.createProxy(url.getHost());
            con = url.openConnection(proxy);
            if (p.getUserName() != null) {
                Authenticator.setDefault(p.authenticator);
                p.jenkins48775workaround(proxy, url);
            }
        }
        if (DEFAULT_CONNECT_TIMEOUT_MILLIS > 0) {
            con.setConnectTimeout(DEFAULT_CONNECT_TIMEOUT_MILLIS);
        }
        if (JenkinsJVM.isJenkinsJVM()) {
            ProxyConfiguration.decorate(con);
        }
        return con;
    }

    @Deprecated
    public static InputStream getInputStream(URL url) throws IOException {
        ProxyConfiguration p = ProxyConfiguration.get();
        if (p == null) {
            return new RetryableHttpStream(url);
        }
        Proxy proxy = p.createProxy(url.getHost());
        RetryableHttpStream is = new RetryableHttpStream(url, proxy);
        if (p.getUserName() != null) {
            Authenticator.setDefault(p.authenticator);
            p.jenkins48775workaround(proxy, url);
        }
        return is;
    }

    public static HttpClient newHttpClient() {
        return ProxyConfiguration.newHttpClientBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
    }

    public static HttpClient.Builder newHttpClientBuilder() {
        HttpClient.Builder httpClientBuilder = HttpClient.newBuilder();
        ProxyConfiguration proxyConfiguration = ProxyConfiguration.get();
        if (proxyConfiguration != null) {
            if (proxyConfiguration.getName() != null) {
                httpClientBuilder.proxy(new JenkinsProxySelector(proxyConfiguration.getName(), proxyConfiguration.getPort(), proxyConfiguration.getNoProxyHost()));
            }
            if (proxyConfiguration.getUserName() != null) {
                httpClientBuilder.authenticator(proxyConfiguration.authenticator);
            }
        }
        if (DEFAULT_CONNECT_TIMEOUT_MILLIS > 0) {
            httpClientBuilder.connectTimeout(Duration.ofMillis(DEFAULT_CONNECT_TIMEOUT_MILLIS));
        }
        httpClientBuilder.executor(httpClientExecutor);
        return httpClientBuilder;
    }

    public static HttpRequest.Builder newHttpRequestBuilder(URI uri) {
        HttpRequest.Builder httpRequestBuilder = HttpRequest.newBuilder(uri);
        if (JenkinsJVM.isJenkinsJVM() && !UserAgentURLConnectionDecorator.DISABLED) {
            httpRequestBuilder.setHeader("User-Agent", UserAgentURLConnectionDecorator.getUserAgent());
        }
        return httpRequestBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jenkins48775workaround(Proxy proxy, URL url) {
        if ("https".equals(url.getProtocol()) && !this.authCacheSeeded && proxy != Proxy.NO_PROXY) {
            HttpURLConnection preAuth = null;
            try {
                preAuth = (HttpURLConnection)new URL("http", url.getHost(), -1, "/").openConnection(proxy);
                preAuth.setRequestMethod("HEAD");
                preAuth.connect();
            }
            catch (IOException iOException) {
            }
            finally {
                if (preAuth != null) {
                    preAuth.disconnect();
                }
            }
            this.authCacheSeeded = true;
        } else if ("https".equals(url.getProtocol())) {
            this.authCacheSeeded = this.authCacheSeeded || proxy != Proxy.NO_PROXY;
        }
    }

    @CheckForNull
    private static ProxyConfiguration get() {
        if (JenkinsJVM.isJenkinsJVM()) {
            return ProxyConfiguration._get();
        }
        return null;
    }

    @CheckForNull
    private static ProxyConfiguration _get() {
        JenkinsJVM.checkJenkinsJVM();
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        return jenkins == null ? null : jenkins.proxy;
    }

    private static void decorate(URLConnection con) throws IOException {
        for (URLConnectionDecorator d : URLConnectionDecorator.all()) {
            d.decorate(con);
        }
    }

    static {
        XSTREAM.alias("proxy", ProxyConfiguration.class);
    }

    private static class JenkinsProxySelector
    extends ProxySelector {
        @NonNull
        private final Proxy proxy;
        @CheckForNull
        private final String exclusions;

        private JenkinsProxySelector(@NonNull String hostname, int port, @CheckForNull String exclusions) {
            this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(hostname, port));
            this.exclusions = exclusions;
        }

        @Override
        public void connectFailed(URI uri, SocketAddress sa, IOException e) {
        }

        @Override
        public List<Proxy> select(URI uri) {
            boolean excluded;
            Objects.requireNonNull(uri);
            String scheme = Objects.requireNonNull(uri.getScheme());
            String host = Objects.requireNonNull(uri.getHost());
            boolean bl = excluded = this.exclusions != null && ProxyConfiguration.isExcluded(host.toLowerCase(), this.exclusions);
            if (!excluded && (scheme.equalsIgnoreCase("http") || scheme.equalsIgnoreCase("https"))) {
                return List.of(this.proxy);
            }
            return List.of(Proxy.NO_PROXY);
        }
    }

    @Extension
    @Symbol(value={"proxy"})
    public static class DescriptorImpl
    extends Descriptor<ProxyConfiguration> {
        @Override
        @NonNull
        public String getDisplayName() {
            return "Proxy Configuration";
        }

        public FormValidation doCheckPort(@QueryParameter String value) {
            int port;
            if ((value = Util.fixEmptyAndTrim(value)) == null) {
                return FormValidation.ok();
            }
            try {
                port = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return FormValidation.error(Messages.PluginManager_PortNotANumber());
            }
            if (port < 0 || port > 65535) {
                return FormValidation.error(Messages.PluginManager_PortNotInRange(0, 65535));
            }
            return FormValidation.ok();
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public FormValidation doValidateProxy(@QueryParameter(value="testUrl") String testUrl, @QueryParameter(value="name") String name, @QueryParameter(value="port") int port, @QueryParameter(value="userName") String userName, @QueryParameter(value="secretPassword") Secret password, @QueryParameter(value="noProxyHost") String noProxyHost) throws InterruptedException {
            HttpRequest httpRequest;
            URI uri;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            testUrl = Util.fixEmptyAndTrim(testUrl);
            if (testUrl == null) {
                return FormValidation.error(Messages.ProxyConfiguration_TestUrlRequired());
            }
            try {
                uri = new URI(testUrl);
            }
            catch (URISyntaxException e) {
                return FormValidation.error(e, Messages.ProxyConfiguration_MalformedTestUrl(testUrl));
            }
            HttpClient.Builder builder = HttpClient.newBuilder();
            builder.connectTimeout(DEFAULT_CONNECT_TIMEOUT_MILLIS > 0 ? Duration.ofMillis(DEFAULT_CONNECT_TIMEOUT_MILLIS) : Duration.ofSeconds(30L));
            if (Util.fixEmptyAndTrim(name) != null && !this.isNoProxyHost(uri.getHost(), noProxyHost)) {
                builder.proxy(ProxySelector.of(new InetSocketAddress(name, port)));
                Authenticator authenticator = DescriptorImpl.newValidationAuthenticator(userName, password != null ? password.getPlainText() : null);
                builder.authenticator(authenticator);
            }
            HttpClient httpClient = builder.build();
            try {
                httpRequest = ProxyConfiguration.newHttpRequestBuilder(uri).method("HEAD", HttpRequest.BodyPublishers.noBody()).build();
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error(e, Messages.ProxyConfiguration_MalformedTestUrl(testUrl));
            }
            try {
                HttpResponse<Void> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.discarding());
                if (httpResponse.statusCode() < 400) {
                    return FormValidation.ok(Messages.ProxyConfiguration_Success(httpResponse.statusCode()));
                }
                return FormValidation.error(Messages.ProxyConfiguration_FailedToConnect(testUrl, httpResponse.statusCode()));
            }
            catch (IOException e) {
                return FormValidation.error(e, Messages.ProxyConfiguration_FailedToConnectViaProxy(testUrl));
            }
        }

        private boolean isNoProxyHost(String host, String noProxyHost) {
            if (host != null && noProxyHost != null) {
                for (Pattern p : ProxyConfiguration.getNoProxyHostPatterns(noProxyHost)) {
                    if (!p.matcher(host).matches()) continue;
                    return true;
                }
            }
            return false;
        }

        private static Authenticator newValidationAuthenticator(final String userName, final String password) {
            return new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(userName, Secret.fromString(password).getPlainText().toCharArray());
                }
            };
        }
    }
}

