/*
 * Decompiled with CFR 0.152.
 */
package hudson.console;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionPoint;
import hudson.MarkupText;
import hudson.console.ConsoleAnnotationDescriptor;
import hudson.console.ConsoleAnnotator;
import hudson.model.Describable;
import hudson.remoting.ClassFilter;
import hudson.remoting.ObjectInputStreamEx;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jenkins.model.Jenkins;
import jenkins.security.HMACConfidentialKey;
import jenkins.util.JenkinsJVM;
import jenkins.util.SystemProperties;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.remoting.util.AnonymousClassWarnings;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class ConsoleNote<T>
implements Serializable,
Describable<ConsoleNote<?>>,
ExtensionPoint {
    private static final HMACConfidentialKey MAC = new HMACConfidentialKey(ConsoleNote.class, "MAC");
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="nonfinal for tests & script console")
    public static boolean INSECURE = SystemProperties.getBoolean(ConsoleNote.class.getName() + ".INSECURE");
    private static final long serialVersionUID = 1L;
    public static final String PREAMBLE_STR = "\u001b[8mha:";
    public static final String POSTAMBLE_STR = "\u001b[0m";
    @SuppressFBWarnings(value={"MS_PKGPROTECT"}, justification="used in several plugins")
    public static final byte[] PREAMBLE = "\u001b[8mha:".getBytes(StandardCharsets.UTF_8);
    @SuppressFBWarnings(value={"MS_PKGPROTECT"}, justification="used in several plugins")
    public static final byte[] POSTAMBLE = "\u001b[0m".getBytes(StandardCharsets.UTF_8);

    public abstract ConsoleAnnotator annotate(T var1, MarkupText var2, int var3);

    public ConsoleAnnotationDescriptor getDescriptor() {
        return (ConsoleAnnotationDescriptor)Jenkins.get().getDescriptorOrDie(this.getClass());
    }

    public void encodeTo(OutputStream out) throws IOException {
        out.write(this.encodeToBytes().toByteArray());
    }

    public void encodeTo(Writer out) throws IOException {
        out.write(this.encodeToBytes().toString());
    }

    private ByteArrayOutputStream encodeToBytes() throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try (GZIPOutputStream gzos = new GZIPOutputStream(buf);
             ObjectOutputStream oos = JenkinsJVM.isJenkinsJVM() ? AnonymousClassWarnings.checkingObjectOutputStream((OutputStream)gzos) : new ObjectOutputStream(gzos);){
            oos.writeObject(this);
        }
        ByteArrayOutputStream buf2 = new ByteArrayOutputStream();
        try (DataOutputStream dos = new DataOutputStream(Base64.getEncoder().wrap(buf2));){
            buf2.write(PREAMBLE);
            if (JenkinsJVM.isJenkinsJVM()) {
                byte[] mac = MAC.mac(buf.toByteArray());
                dos.writeInt(-mac.length);
                dos.write(mac);
            }
            dos.writeInt(buf.size());
            buf.writeTo(dos);
        }
        buf2.write(POSTAMBLE);
        return buf2;
    }

    public String encode() throws IOException {
        return this.encodeToBytes().toString();
    }

    public static ConsoleNote readFrom(DataInputStream in) throws IOException, ClassNotFoundException {
        ConsoleNote consoleNote;
        byte[] buf;
        byte[] mac;
        byte[] preamble = new byte[PREAMBLE.length];
        in.readFully(preamble);
        if (!Arrays.equals(preamble, PREAMBLE)) {
            return null;
        }
        try (DataInputStream decoded = new DataInputStream(Base64.getDecoder().wrap(in));){
            int sz;
            int macSz = -decoded.readInt();
            if (macSz > 0) {
                mac = new byte[macSz];
                decoded.readFully(mac);
                sz = decoded.readInt();
                if (sz < 0) {
                    throw new IOException("Corrupt stream");
                }
            } else {
                mac = null;
                sz = -macSz;
            }
            buf = new byte[sz];
            decoded.readFully(buf);
        }
        byte[] postamble = new byte[POSTAMBLE.length];
        in.readFully(postamble);
        if (!Arrays.equals(postamble, POSTAMBLE)) {
            return null;
        }
        if (!INSECURE) {
            if (mac == null) {
                throw new IOException("Refusing to deserialize unsigned note from an old log.");
            }
            if (!MAC.checkMac(buf, mac)) {
                throw new IOException("MAC mismatch");
            }
        }
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        ObjectInputStreamEx ois = new ObjectInputStreamEx((InputStream)new GZIPInputStream(new ByteArrayInputStream(buf)), jenkins != null ? jenkins.pluginManager.uberClassLoader : ConsoleNote.class.getClassLoader(), ClassFilter.DEFAULT);
        try {
            consoleNote = ConsoleNote.getConsoleNote((ObjectInputStream)ois);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Error e) {
                throw new IOException(e);
            }
        }
        ois.close();
        return consoleNote;
    }

    @SuppressFBWarnings(value={"OBJECT_DESERIALIZATION"}, justification="Deserialization is protected by logic.")
    private static ConsoleNote getConsoleNote(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        return (ConsoleNote)ois.readObject();
    }

    public static void skip(DataInputStream in) throws IOException {
        int sz;
        byte[] preamble = new byte[PREAMBLE.length];
        in.readFully(preamble);
        if (!Arrays.equals(preamble, PREAMBLE)) {
            return;
        }
        DataInputStream decoded = new DataInputStream(Base64.getDecoder().wrap(in));
        int macSz = -decoded.readInt();
        if (macSz > 0) {
            IOUtils.skipFully((InputStream)decoded, (long)macSz);
            sz = decoded.readInt();
            IOUtils.skipFully((InputStream)decoded, (long)sz);
        } else {
            sz = -macSz;
            IOUtils.skipFully((InputStream)decoded, (long)sz);
        }
        byte[] postamble = new byte[POSTAMBLE.length];
        in.readFully(postamble);
    }

    public static int findPreamble(byte[] buf, int start, int len) {
        int e = start + len - PREAMBLE.length + 1;
        block0: for (int i = start; i < e; ++i) {
            if (buf[i] != PREAMBLE[0]) continue;
            for (int j = 1; j < PREAMBLE.length; ++j) {
                if (buf[i + j] != PREAMBLE[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static List<String> removeNotes(Collection<String> logLines) {
        ArrayList<String> r = new ArrayList<String>(logLines.size());
        for (String l : logLines) {
            r.add(ConsoleNote.removeNotes(l));
        }
        return r;
    }

    public static String removeNotes(String line) {
        int idx;
        while ((idx = ((String)line).indexOf(PREAMBLE_STR)) >= 0) {
            int e = ((String)line).indexOf(POSTAMBLE_STR, idx);
            if (e < 0) {
                return line;
            }
            line = ((String)line).substring(0, idx) + ((String)line).substring(e + POSTAMBLE_STR.length());
        }
        return line;
    }
}

