/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Messages;
import hudson.model.ModifiableItemGroup;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewDescriptor;
import hudson.model.ViewGroup;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.util.SystemProperties;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class AllView
extends View {
    public static final String DEFAULT_VIEW_NAME = "all";
    private static final Logger LOGGER = Logger.getLogger(AllView.class.getName());

    @DataBoundConstructor
    public AllView(String name) {
        super(name);
    }

    public AllView(String name, ViewGroup owner) {
        this(name);
        this.owner = owner;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public boolean contains(TopLevelItem item) {
        return true;
    }

    @Override
    public String getDisplayName() {
        return DEFAULT_VIEW_NAME.equals(this.name) ? Messages.Hudson_ViewName() : this.name;
    }

    @Override
    @RequirePOST
    public Item doCreateItem(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        ItemGroup<? extends TopLevelItem> ig = this.getOwner().getItemGroup();
        if (ig instanceof ModifiableItemGroup) {
            return ((ModifiableItemGroup)ig).doCreateItem(req, rsp);
        }
        return null;
    }

    @Override
    public Collection<TopLevelItem> getItems() {
        return this.getOwner().getItemGroup().getItems();
    }

    @Override
    public String getPostConstructLandingPage() {
        return "";
    }

    @Override
    protected void submit(StaplerRequest req) throws IOException, ServletException, Descriptor.FormException {
    }

    @NonNull
    public static String migrateLegacyPrimaryAllViewLocalizedName(@NonNull List<View> views, @NonNull String primaryView) {
        if (DEFAULT_VIEW_NAME.equals(primaryView)) {
            return primaryView;
        }
        if (SystemProperties.getBoolean(AllView.class.getName() + ".JENKINS-38606", true)) {
            AllView allView = null;
            for (View v : views) {
                if (DEFAULT_VIEW_NAME.equals(v.getViewName())) {
                    return primaryView;
                }
                if (!Objects.equals(v.getViewName(), primaryView)) continue;
                if (v instanceof AllView) {
                    allView = (AllView)v;
                    continue;
                }
                return primaryView;
            }
            if (allView != null) {
                for (Locale l : Locale.getAvailableLocales()) {
                    if (!primaryView.equals(Messages._Hudson_ViewName().toString(l))) continue;
                    LOGGER.log(Level.INFO, "JENKINS-38606 detected for AllView in {0}; renaming view from {1} to {2}", new Object[]{allView.owner, primaryView, DEFAULT_VIEW_NAME});
                    allView.name = DEFAULT_VIEW_NAME;
                    return DEFAULT_VIEW_NAME;
                }
            }
        }
        return primaryView;
    }

    @Extension
    @Symbol(value={"all"})
    public static final class DescriptorImpl
    extends ViewDescriptor {
        @Override
        public boolean isApplicableIn(ViewGroup owner) {
            for (View v : owner.getViews()) {
                if (!(v instanceof AllView)) continue;
                return false;
            }
            return true;
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.Hudson_ViewName();
        }
    }
}

