/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionList;
import hudson.ExtensionListListener;
import hudson.ExtensionPoint;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.triggers.SafeTimerTask;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import jenkins.util.Timer;

@SuppressFBWarnings(value={"PREDICTABLE_RANDOM"}, justification="The random is just used for an initial delay.")
public abstract class PeriodicWork
extends SafeTimerTask
implements ExtensionPoint {
    @Deprecated
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    protected static final long MIN = 60000L;
    protected static final long HOUR = 3600000L;
    protected static final long DAY = 86400000L;
    private static final Random RANDOM = new Random();

    public abstract long getRecurrencePeriod();

    public long getInitialDelay() {
        long l = RANDOM.nextLong();
        if (l == Long.MIN_VALUE) {
            ++l;
        }
        return Math.abs(l) % this.getRecurrencePeriod();
    }

    public static ExtensionList<PeriodicWork> all() {
        return ExtensionList.lookup(PeriodicWork.class);
    }

    @Initializer(after=InitMilestone.JOB_CONFIG_ADAPTED)
    public static void init() {
        ExtensionList<PeriodicWork> extensionList = PeriodicWork.all();
        extensionList.addListener(new PeriodicWorkExtensionListListener(extensionList));
        for (PeriodicWork p : extensionList) {
            PeriodicWork.schedulePeriodicWork(p);
        }
    }

    private static void schedulePeriodicWork(PeriodicWork p) {
        Timer.get().scheduleAtFixedRate(p, p.getInitialDelay(), p.getRecurrencePeriod(), TimeUnit.MILLISECONDS);
    }

    private static class PeriodicWorkExtensionListListener
    extends ExtensionListListener {
        private final Set<PeriodicWork> registered = new HashSet<PeriodicWork>();

        PeriodicWorkExtensionListListener(ExtensionList<PeriodicWork> initiallyRegistered) {
            this.registered.addAll(initiallyRegistered);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange() {
            Set<PeriodicWork> set = this.registered;
            synchronized (set) {
                for (PeriodicWork p : PeriodicWork.all()) {
                    if (this.registered.contains(p)) continue;
                    PeriodicWork.schedulePeriodicWork(p);
                    this.registered.add(p);
                }
            }
        }
    }
}

