/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.console.ConsoleNote;
import hudson.console.HyperlinkNote;
import hudson.model.NullTaskListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jenkinsci.remoting.SerializableOnlyOverRemoting;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.ProtectedExternally;

public interface TaskListener
extends SerializableOnlyOverRemoting {
    public static final TaskListener NULL = new NullTaskListener();

    @NonNull
    public PrintStream getLogger();

    @Restricted(value={ProtectedExternally.class})
    @NonNull
    default public Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    private PrintWriter _error(String prefix, String msg) {
        PrintStream out = this.getLogger();
        out.print(prefix);
        out.println(msg);
        Charset charset = this.getCharset();
        return new PrintWriter((Writer)new OutputStreamWriter((OutputStream)out, charset), true);
    }

    default public void annotate(ConsoleNote ann) throws IOException {
        ann.encodeTo(this.getLogger());
    }

    default public void hyperlink(String url, String text) throws IOException {
        this.annotate(new HyperlinkNote(url, text.length()));
        this.getLogger().print(text);
    }

    @NonNull
    default public PrintWriter error(String msg) {
        return this._error("ERROR: ", msg);
    }

    @NonNull
    default public PrintWriter error(String format, Object ... args) {
        return this.error(String.format(format, args));
    }

    @NonNull
    default public PrintWriter fatalError(String msg) {
        return this._error("FATAL: ", msg);
    }

    @NonNull
    default public PrintWriter fatalError(String format, Object ... args) {
        return this.fatalError(String.format(format, args));
    }
}

