/*
 * Decompiled with CFR 0.152.
 */
package hudson.model.queue;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Queue;

public abstract class ScheduleResult {
    public boolean isCreated() {
        return false;
    }

    public boolean isRefused() {
        return false;
    }

    @CheckForNull
    public Queue.Item getItem() {
        return null;
    }

    @CheckForNull
    public Queue.WaitingItem getCreateItem() {
        return null;
    }

    public final boolean isAccepted() {
        return !this.isRefused();
    }

    public static Created created(Queue.WaitingItem i) {
        return new Created(i);
    }

    public static Existing existing(Queue.Item i) {
        return new Existing(i);
    }

    public static Refused refused() {
        return new Refused();
    }

    public static final class Created
    extends ScheduleResult {
        private final Queue.WaitingItem item;

        private Created(Queue.WaitingItem item) {
            this.item = item;
        }

        @Override
        public boolean isCreated() {
            return true;
        }

        @Override
        public Queue.WaitingItem getCreateItem() {
            return this.item;
        }

        @Override
        public Queue.Item getItem() {
            return this.item;
        }
    }

    public static final class Existing
    extends ScheduleResult {
        private final Queue.Item item;

        private Existing(Queue.Item item) {
            this.item = item;
        }

        @Override
        public Queue.Item getItem() {
            return this.item;
        }
    }

    public static final class Refused
    extends ScheduleResult {
        @Override
        public boolean isRefused() {
            return true;
        }
    }
}

