/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Hudson;
import hudson.security.Permission;
import hudson.security.PermissionScope;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jvnet.localizer.Localizable;

public final class PermissionGroup
implements Iterable<Permission>,
Comparable<PermissionGroup> {
    private final SortedSet<Permission> permissions = new TreeSet<Permission>(Permission.ID_COMPARATOR);
    @NonNull
    public final Class owner;
    public final Localizable title;
    private final String id;
    private static final SortedSet<PermissionGroup> PERMISSIONS = new TreeSet<PermissionGroup>();

    public PermissionGroup(@NonNull Class owner, Localizable title) throws IllegalStateException {
        this(title.toString(Locale.ENGLISH), owner, title);
    }

    public PermissionGroup(String id, @NonNull Class owner, Localizable title) throws IllegalStateException {
        this.owner = owner;
        this.title = title;
        this.id = id;
        PermissionGroup.register(this);
    }

    public String getId() {
        return this.id;
    }

    public String getOwnerClassName() {
        return this.owner.getName();
    }

    @Override
    public Iterator<Permission> iterator() {
        return this.getPermissions().iterator();
    }

    synchronized void add(Permission p) {
        if (!this.permissions.add(p)) {
            throw new IllegalStateException("attempt to register a second Permission for " + p.getId());
        }
    }

    public synchronized List<Permission> getPermissions() {
        return new ArrayList<Permission>(this.permissions);
    }

    public synchronized boolean hasPermissionContainedBy(PermissionScope scope) {
        for (Permission p : this.permissions) {
            if (!p.isContainedBy(scope)) continue;
            return true;
        }
        return false;
    }

    public synchronized Permission find(String name) {
        for (Permission p : this.permissions) {
            if (!p.name.equals(name)) continue;
            return p;
        }
        return null;
    }

    @Override
    public int compareTo(PermissionGroup that) {
        int r = this.compareOrder() - that.compareOrder();
        if (r != 0) {
            return r;
        }
        return this.getOwnerClassName().compareTo(that.getOwnerClassName());
    }

    private int compareOrder() {
        if (this.owner == Hudson.class) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object o) {
        return o instanceof PermissionGroup && this.getOwnerClassName().equals(((PermissionGroup)o).getOwnerClassName());
    }

    public int hashCode() {
        return this.getOwnerClassName().hashCode();
    }

    public synchronized int size() {
        return this.permissions.size();
    }

    public String toString() {
        return "PermissionGroup[" + this.getOwnerClassName() + "]";
    }

    private static synchronized void register(PermissionGroup g) {
        if (!PERMISSIONS.add(g)) {
            throw new IllegalStateException("attempt to register a second PermissionGroup for " + g.getOwnerClassName());
        }
    }

    public static synchronized List<PermissionGroup> getAll() {
        return new ArrayList<PermissionGroup>(PERMISSIONS);
    }

    @CheckForNull
    public static synchronized PermissionGroup get(Class owner) {
        for (PermissionGroup g : PERMISSIONS) {
            if (g.owner != owner) continue;
            return g;
        }
        return null;
    }
}

