/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.console.ModelHyperlinkNote;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Messages;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.DependencyDeclarer;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.springframework.security.core.Authentication;

public class BuildTrigger
extends Recorder
implements DependencyDeclarer {
    private String childProjects;
    private final Result threshold;
    private static final Logger LOGGER = Logger.getLogger(BuildTrigger.class.getName());

    public BuildTrigger(String childProjects, boolean evenIfUnstable) {
        this(childProjects, evenIfUnstable ? Result.UNSTABLE : Result.SUCCESS);
    }

    @DataBoundConstructor
    public BuildTrigger(String childProjects, String threshold) {
        this(childProjects, Result.fromString(Objects.toString(threshold, Result.SUCCESS.toString())));
    }

    public BuildTrigger(String childProjects, Result threshold) {
        if (childProjects == null) {
            throw new IllegalArgumentException();
        }
        this.childProjects = childProjects;
        this.threshold = threshold;
    }

    public BuildTrigger(List<AbstractProject> childProjects, Result threshold) {
        this((Collection<? extends AbstractProject>)childProjects, threshold);
    }

    public BuildTrigger(Collection<? extends AbstractProject> childProjects, Result threshold) {
        this(Items.toNameList(childProjects), threshold);
    }

    public String getChildProjectsValue() {
        return this.childProjects;
    }

    public Result getThreshold() {
        if (this.threshold == null) {
            return Result.SUCCESS;
        }
        return this.threshold;
    }

    @Deprecated
    public List<AbstractProject> getChildProjects() {
        return this.getChildProjects(Jenkins.get());
    }

    @Deprecated
    public List<AbstractProject> getChildProjects(AbstractProject owner) {
        return this.getChildProjects(owner == null ? null : owner.getParent());
    }

    @Deprecated
    public List<AbstractProject> getChildProjects(ItemGroup base) {
        return Items.fromNameList(base, this.childProjects, AbstractProject.class);
    }

    @NonNull
    public List<Job<?, ?>> getChildJobs(@NonNull AbstractProject<?, ?> owner) {
        return Items.fromNameList(owner.getParent(), this.childProjects, Job.class);
    }

    @Override
    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Deprecated
    public boolean hasSame(AbstractProject owner, Collection<? extends AbstractProject> projects) {
        List<AbstractProject> children = this.getChildProjects(owner);
        return children.size() == projects.size() && children.containsAll(projects);
    }

    @Deprecated
    public boolean hasSame(Collection<? extends AbstractProject> projects) {
        return this.hasSame(null, projects);
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        ArrayList jobs = new ArrayList();
        for (Job<?, ?> job : this.getChildJobs((AbstractProject<?, ?>)build.getProject())) {
            if (job instanceof AbstractProject) continue;
            jobs.add(job);
        }
        if (!jobs.isEmpty() && build.getResult().isBetterOrEqualTo(this.threshold)) {
            PrintStream logger = listener.getLogger();
            for (Job job : jobs) {
                if (Jenkins.get().getItemByFullName(job.getFullName()) != job) {
                    LOGGER.log(Level.WARNING, "Running as {0} cannot even see {1} for trigger from {2}", new Object[]{Jenkins.getAuthentication2().getName(), job, build.getParent()});
                    continue;
                }
                if (!job.hasPermission(Item.BUILD)) {
                    listener.getLogger().println(Messages.BuildTrigger_you_have_no_permission_to_build_(ModelHyperlinkNote.encodeTo(job)));
                    continue;
                }
                if (!(job instanceof ParameterizedJobMixIn.ParameterizedJob)) {
                    logger.println(Messages.BuildTrigger_NotBuildable(ModelHyperlinkNote.encodeTo(job)));
                    continue;
                }
                ParameterizedJobMixIn.ParameterizedJob pj = (ParameterizedJobMixIn.ParameterizedJob)((Object)job);
                if (pj.isDisabled()) {
                    logger.println(Messages.BuildTrigger_Disabled(ModelHyperlinkNote.encodeTo(job)));
                    continue;
                }
                if (!job.isBuildable()) {
                    logger.println(Messages.BuildTrigger_NotBuildable(ModelHyperlinkNote.encodeTo(job)));
                    continue;
                }
                boolean scheduled = pj.scheduleBuild(pj.getQuietPeriod(), new Cause.UpstreamCause(build));
                if (Jenkins.get().getItemByFullName(job.getFullName()) != job) continue;
                String name = ModelHyperlinkNote.encodeTo(job);
                if (scheduled) {
                    logger.println(Messages.BuildTrigger_Triggering(name));
                    continue;
                }
                logger.println(Messages.BuildTrigger_InQueue(name));
            }
        }
        return true;
    }

    @Deprecated
    public static boolean execute(AbstractBuild build, BuildListener listener, BuildTrigger trigger) {
        return BuildTrigger.execute(build, listener);
    }

    public static boolean execute(AbstractBuild build, BuildListener listener) {
        DependencyGraph graphTemp;
        PrintStream logger = listener.getLogger();
        try {
            Future<DependencyGraph> futureDependencyGraph = Jenkins.get().getFutureDependencyGraph();
            graphTemp = futureDependencyGraph != null ? futureDependencyGraph.get() : Jenkins.get().getDependencyGraph();
        }
        catch (IllegalStateException | InterruptedException | ExecutionException e) {
            graphTemp = Jenkins.get().getDependencyGraph();
        }
        final DependencyGraph graph = graphTemp;
        ArrayList<DependencyGraph.Dependency> downstreamProjects = new ArrayList<DependencyGraph.Dependency>(graph.getDownstreamDependencies((AbstractProject)build.getProject()));
        downstreamProjects.sort(new Comparator<DependencyGraph.Dependency>(){

            @Override
            public int compare(DependencyGraph.Dependency lhs, DependencyGraph.Dependency rhs) {
                return graph.compare(rhs.getDownstreamProject(), lhs.getDownstreamProject());
            }
        });
        for (DependencyGraph.Dependency dep : downstreamProjects) {
            ArrayList<Action> buildActions;
            if (!dep.shouldTriggerBuild(build, listener, buildActions = new ArrayList<Action>())) continue;
            AbstractProject p = dep.getDownstreamProject();
            if (p.isDisabled()) {
                logger.println(Messages.BuildTrigger_Disabled(ModelHyperlinkNote.encodeTo(p)));
                continue;
            }
            boolean scheduled = p.scheduleBuild(p.getQuietPeriod(), new Cause.UpstreamCause(build), buildActions.toArray(new Action[0]));
            if (Jenkins.get().getItemByFullName(p.getFullName()) != p) continue;
            String name = ModelHyperlinkNote.encodeTo(p);
            if (scheduled) {
                logger.println(Messages.BuildTrigger_Triggering(name));
                continue;
            }
            logger.println(Messages.BuildTrigger_InQueue(name));
        }
        return true;
    }

    @Override
    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        for (AbstractProject p : this.getChildProjects(owner)) {
            graph.addDependency(new DependencyGraph.Dependency(owner, p){

                @Override
                @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="TODO needs triage")
                public boolean shouldTriggerBuild(AbstractBuild build, TaskListener listener, List<Action> actions) {
                    AbstractProject downstream = this.getDownstreamProject();
                    if (Jenkins.get().getItemByFullName(downstream.getFullName()) != downstream) {
                        LOGGER.log(Level.WARNING, "Running as {0} cannot even see {1} for trigger from {2}", new Object[]{Jenkins.getAuthentication2().getName(), downstream, this.getUpstreamProject()});
                        return false;
                    }
                    if (!downstream.hasPermission(Item.BUILD)) {
                        listener.getLogger().println(Messages.BuildTrigger_you_have_no_permission_to_build_(ModelHyperlinkNote.encodeTo(downstream)));
                        return false;
                    }
                    return build.getResult().isBetterOrEqualTo(BuildTrigger.this.threshold);
                }
            });
        }
    }

    @Override
    public boolean needsToRunAfterFinalized() {
        return true;
    }

    @Deprecated
    public boolean onJobRenamed(String oldName, String newName) {
        if (!this.childProjects.contains(oldName)) {
            return false;
        }
        boolean changed = false;
        CharSequence[] projects = this.childProjects.split(",");
        for (int i = 0; i < projects.length; ++i) {
            if (!projects[i].trim().equals(oldName)) continue;
            projects[i] = newName;
            changed = true;
        }
        if (changed) {
            this.childProjects = String.join((CharSequence)",", projects);
        }
        return changed;
    }

    private Object readResolve() {
        if (this.childProjects == null) {
            this.childProjects = "";
            return "";
        }
        return this;
    }

    @Extension
    @Symbol(value={"downstream"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.BuildTrigger_DisplayName();
        }

        @Override
        public String getHelpFile() {
            return "/help/project-config/downstream.html";
        }

        @Override
        public BuildTrigger newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String childProjectsString = formData.getString("childProjects").trim();
            if (childProjectsString.endsWith(",")) {
                childProjectsString = childProjectsString.substring(0, childProjectsString.length() - 1).trim();
            }
            return new BuildTrigger(childProjectsString, formData.optString("threshold", Result.SUCCESS.toString()));
        }

        @Override
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public boolean showEvenIfUnstableOption(@CheckForNull Class<? extends AbstractProject<?, ?>> jobType) {
            return jobType == null || !jobType.getName().contains("PromotionProcess");
        }

        public FormValidation doCheck(@AncestorInPath AbstractProject project, @QueryParameter String value) {
            if (project == null) {
                return FormValidation.ok(Messages.BuildTrigger_ok_ancestor_is_null());
            }
            if (!project.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            StringTokenizer tokens = new StringTokenizer(Util.fixNull(value), ",");
            boolean hasProjects = false;
            while (tokens.hasMoreTokens()) {
                String projectName = tokens.nextToken().trim();
                if (projectName == null || projectName.isBlank()) continue;
                Item item = Jenkins.get().getItem(projectName, project, Item.class);
                if (item == null) {
                    Job nearest = Items.findNearest(Job.class, projectName, project.getParent());
                    String alternative = nearest != null ? nearest.getRelativeNameFrom(project) : "?";
                    return FormValidation.error(Messages.BuildTrigger_NoSuchProject(projectName, alternative));
                }
                if (!(item instanceof ParameterizedJobMixIn.ParameterizedJob)) {
                    return FormValidation.error(Messages.BuildTrigger_NotBuildable(projectName));
                }
                Authentication auth = Tasks.getAuthenticationOf2(project);
                if (!item.hasPermission2(auth, Item.BUILD)) {
                    return FormValidation.error(Messages.BuildTrigger_you_have_no_permission_to_build_(projectName));
                }
                hasProjects = true;
            }
            if (!hasProjects) {
                return FormValidation.error(Messages.BuildTrigger_NoProjectSpecified());
            }
            return FormValidation.ok();
        }

        public AutoCompletionCandidates doAutoCompleteChildProjects(@QueryParameter String value, @AncestorInPath Item self, @AncestorInPath ItemGroup container) {
            return AutoCompletionCandidates.ofJobNames(Job.class, value, self, container);
        }

        @Extension
        public static class ItemListenerImpl
        extends ItemListener {
            @Override
            public void onLocationChanged(Item item, String oldFullName, String newFullName) {
                try (ACLContext acl = ACL.as2(ACL.SYSTEM2);){
                    this.locationChanged(item, oldFullName, newFullName);
                }
            }

            private void locationChanged(Item item, String oldFullName, String newFullName) {
                for (Project p : Jenkins.get().allItems(Project.class)) {
                    String cp2;
                    BuildTrigger t = (BuildTrigger)p.getPublishersList().get(BuildTrigger.class);
                    if (t == null || (cp2 = Items.computeRelativeNamesAfterRenaming(oldFullName, newFullName, t.childProjects, p.getParent())).equals(t.childProjects)) continue;
                    t.childProjects = cp2;
                    try {
                        p.save();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to persist project setting during rename from " + oldFullName + " to " + newFullName, e);
                    }
                }
            }
        }
    }
}

