/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileUploadByteCountLimitException;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.FileUploadFileCountLimitException;
import org.apache.commons.fileupload2.core.FileUploadSizeException;
import org.apache.commons.fileupload2.javax.JavaxServletDiskFileUpload;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class MultipartFormDataParser
implements AutoCloseable {
    private final Map<String, org.apache.commons.fileupload2.core.FileItem> byName = new HashMap<String, org.apache.commons.fileupload2.core.FileItem>();
    private static int FILEUPLOAD_MAX_FILES = Integer.getInteger(MultipartFormDataParser.class.getName() + ".FILEUPLOAD_MAX_FILES", 1000);
    private static long FILEUPLOAD_MAX_FILE_SIZE = Long.getLong(MultipartFormDataParser.class.getName() + ".FILEUPLOAD_MAX_FILE_SIZE", -1L);
    private static long FILEUPLOAD_MAX_SIZE = Long.getLong(MultipartFormDataParser.class.getName() + ".FILEUPLOAD_MAX_SIZE", -1L);

    @Restricted(value={NoExternalUse.class})
    public MultipartFormDataParser(HttpServletRequest request, int maxParts, long maxPartSize, long maxSize) throws ServletException {
        File tmpDir;
        try {
            tmpDir = Files.createTempDirectory("jenkins-multipart-uploads", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new ServletException("Error creating temporary directory", (Throwable)e);
        }
        tmpDir.deleteOnExit();
        JavaxServletDiskFileUpload upload = new JavaxServletDiskFileUpload(((DiskFileItemFactory.Builder)DiskFileItemFactory.builder().setFile(tmpDir)).get());
        upload.setFileCountMax((long)maxParts);
        upload.setFileSizeMax(maxPartSize);
        upload.setSizeMax(maxSize);
        try {
            for (org.apache.commons.fileupload2.core.FileItem fi : upload.parseRequest(request)) {
                this.byName.put(fi.getFieldName(), fi);
            }
        }
        catch (FileUploadFileCountLimitException e) {
            throw new ServletException("File upload field count limit exceeded. Consider setting the Java system property " + MultipartFormDataParser.class.getName() + ".FILEUPLOAD_MAX_FILES to a value greater than " + FILEUPLOAD_MAX_FILES + ", or to -1 to disable this limit.", (Throwable)e);
        }
        catch (FileUploadByteCountLimitException e) {
            throw new ServletException("File upload field size limit exceeded. Consider setting the Java system property " + MultipartFormDataParser.class.getName() + ".FILEUPLOAD_MAX_FILE_SIZE to a value greater than " + FILEUPLOAD_MAX_FILE_SIZE + ", or to -1 to disable this limit.", (Throwable)e);
        }
        catch (FileUploadSizeException e) {
            throw new ServletException("File upload total size limit exceeded. Consider setting the Java system property " + MultipartFormDataParser.class.getName() + ".FILEUPLOAD_MAX_SIZE to a value greater than " + FILEUPLOAD_MAX_SIZE + ", or to -1 to disable this limit.", (Throwable)e);
        }
        catch (FileUploadException e) {
            throw new ServletException((Throwable)e);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public MultipartFormDataParser(HttpServletRequest request, int maxParts) throws ServletException {
        this(request, maxParts, FILEUPLOAD_MAX_FILE_SIZE, FILEUPLOAD_MAX_SIZE);
    }

    public MultipartFormDataParser(HttpServletRequest request) throws ServletException {
        this(request, FILEUPLOAD_MAX_FILES, FILEUPLOAD_MAX_FILE_SIZE, FILEUPLOAD_MAX_SIZE);
    }

    public String get(String key) {
        org.apache.commons.fileupload2.core.FileItem fi = this.byName.get(key);
        if (fi == null) {
            return null;
        }
        return fi.getString();
    }

    public org.apache.commons.fileupload2.core.FileItem getFileItem2(String key) {
        return this.byName.get(key);
    }

    @Deprecated
    public FileItem getFileItem(String key) {
        return FileItem.fromFileUpload2FileItem((org.apache.commons.fileupload2.core.FileItem)this.getFileItem2(key));
    }

    public void cleanUp() {
        for (org.apache.commons.fileupload2.core.FileItem item : this.byName.values()) {
            try {
                item.delete();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    @Override
    public void close() {
        this.cleanUp();
    }

    public static boolean isMultiPartForm(@CheckForNull String contentType) {
        if (contentType == null) {
            return false;
        }
        for (String part : contentType.split(";")) {
            if (!"multipart/form-data".equals(part)) continue;
            return true;
        }
        return false;
    }
}

