/*
 * Decompiled with CFR 0.152.
 */
package jenkins.console;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.User;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.console.ConsoleUrlProviderGlobalConfiguration;
import jenkins.console.ConsoleUrlProviderUserProperty;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;

public interface ConsoleUrlProvider
extends Describable<ConsoleUrlProvider> {
    @Restricted(value={NoExternalUse.class})
    public static final Logger LOGGER = Logger.getLogger(ConsoleUrlProvider.class.getName());

    @CheckForNull
    public String getConsoleUrl(Run<?, ?> var1);

    @Override
    default public Descriptor<ConsoleUrlProvider> getDescriptor() {
        return Jenkins.get().getDescriptorOrDie(this.getClass());
    }

    @NonNull
    public static String getRedirectUrl(Run<?, ?> run) {
        ConsoleUrlProviderGlobalConfiguration globalConfig;
        List<ConsoleUrlProvider> globalProviders;
        List<ConsoleUrlProvider> userProviders;
        ConsoleUrlProviderUserProperty userProperty;
        ArrayList<ConsoleUrlProvider> providers = new ArrayList<ConsoleUrlProvider>();
        User currentUser = User.current();
        if (currentUser != null && (userProperty = currentUser.getProperty(ConsoleUrlProviderUserProperty.class)) != null && (userProviders = userProperty.getProviders()) != null) {
            providers.addAll(userProviders);
        }
        if ((globalProviders = (globalConfig = ConsoleUrlProviderGlobalConfiguration.get()).getProviders()) != null) {
            providers.addAll(globalProviders);
        }
        Object url = null;
        for (ConsoleUrlProvider provider : providers) {
            try {
                String tempUrl = provider.getConsoleUrl(run);
                if (tempUrl == null) continue;
                if (new URI(tempUrl).isAbsolute()) {
                    LOGGER.warning(() -> "Ignoring absolute console URL " + tempUrl + " for " + run + " from " + provider.getClass());
                    continue;
                }
                url = tempUrl;
                break;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e, () -> "Error looking up console URL for " + run + " from " + provider.getClass());
            }
        }
        if (url == null) {
            url = run.getUrl() + "console";
        }
        if (((String)url).startsWith("/")) {
            return Stapler.getCurrentRequest().getContextPath() + (String)url;
        }
        return Stapler.getCurrentRequest().getContextPath() + "/" + (String)url;
    }

    public static boolean isEnabled() {
        return Jenkins.get().getDescriptorList(ConsoleUrlProvider.class).size() > 1;
    }
}

