/*
 * Decompiled with CFR 0.152.
 */
package jenkins.management;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Functions;
import hudson.Util;
import hudson.console.AnnotatedLargeText;
import hudson.model.AdministrativeMonitor;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public abstract class AsynchronousAdministrativeMonitor
extends AdministrativeMonitor {
    private volatile FixThread fixThread;
    private static final Logger LOGGER = Logger.getLogger(AsynchronousAdministrativeMonitor.class.getName());

    public boolean isFixingActive() {
        return this.fixThread != null && this.fixThread.isAlive();
    }

    public AnnotatedLargeText getLogText() {
        return new AnnotatedLargeText<AsynchronousAdministrativeMonitor>(this.getLogFile(), Charset.defaultCharset(), !this.isFixingActive(), this);
    }

    protected File getLogFile() {
        File base = this.getBaseDir();
        try {
            Util.createDirectories(base.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new File(base, "log");
    }

    protected File getBaseDir() {
        return new File(Jenkins.get().getRootDir(), this.getClass().getName());
    }

    @Override
    public abstract String getDisplayName();

    protected synchronized Thread start(boolean forceRestart) {
        if (!forceRestart && this.isFixingActive()) {
            this.fixThread.interrupt();
        }
        if (forceRestart || !this.isFixingActive()) {
            this.fixThread = new FixThread();
            this.fixThread.start();
        }
        return this.fixThread;
    }

    protected abstract void fix(TaskListener var1) throws Exception;

    protected class FixThread
    extends Thread {
        FixThread() {
            super(AsynchronousAdministrativeMonitor.this.getDisplayName());
        }

        @Override
        public void run() {
            StreamTaskListener listener = null;
            try (ACLContext ctx = ACL.as2(ACL.SYSTEM2);){
                listener = new StreamTaskListener(AsynchronousAdministrativeMonitor.this.getLogFile());
                try {
                    this.doRun(listener);
                }
                finally {
                    listener.close();
                }
            }
            catch (IOException ex) {
                if (listener == null) {
                    LOGGER.log(Level.SEVERE, "Cannot create listener for " + this.getName(), ex);
                }
                LOGGER.log(Level.WARNING, "Cannot close listener for " + this.getName(), ex);
            }
        }

        private void doRun(@NonNull TaskListener listener) {
            try {
                AsynchronousAdministrativeMonitor.this.fix(listener);
            }
            catch (AbortException e) {
                listener.error(e.getMessage());
            }
            catch (Throwable e) {
                Functions.printStackTrace(e, listener.error(this.getName() + " failed"));
                LOGGER.log(Level.WARNING, this.getName() + " failed", e);
            }
        }
    }
}

