/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Job;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalBuildDiscarderConfiguration;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@Extension
public class BackgroundGlobalBuildDiscarder
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(BackgroundGlobalBuildDiscarder.class.getName());

    public BackgroundGlobalBuildDiscarder() {
        super("Periodic background build discarder");
    }

    @Override
    protected void execute(TaskListener listener) throws IOException, InterruptedException {
        for (Job job : Jenkins.get().allItems(Job.class)) {
            BackgroundGlobalBuildDiscarder.processJob(listener, job);
        }
    }

    public static void processJob(TaskListener listener, Job job) {
        GlobalBuildDiscarderConfiguration.get().getConfiguredBuildDiscarders().forEach(strategy -> {
            String displayName = strategy.getDescriptor().getDisplayName();
            if (strategy.isApplicable(job)) {
                try {
                    strategy.apply(job);
                }
                catch (Exception ex) {
                    listener.error("An exception occurred when executing " + displayName + ": " + ex.getMessage());
                    LOGGER.log(Level.WARNING, "An exception occurred when executing " + displayName, ex);
                }
            }
        });
    }

    @Override
    public long getRecurrencePeriod() {
        return 3600000L;
    }
}

