/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.Messages;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public abstract class ProjectNamingStrategy
implements Describable<ProjectNamingStrategy>,
ExtensionPoint {
    public static final ProjectNamingStrategy DEFAULT_NAMING_STRATEGY = new DefaultProjectNamingStrategy();

    public ProjectNamingStrategyDescriptor getDescriptor() {
        return (ProjectNamingStrategyDescriptor)Jenkins.get().getDescriptor(this.getClass());
    }

    public static DescriptorExtensionList<ProjectNamingStrategy, ProjectNamingStrategyDescriptor> all() {
        return Jenkins.get().getDescriptorList(ProjectNamingStrategy.class);
    }

    @Deprecated
    public void checkName(String name) throws Failure {
    }

    public void checkName(String parentName, String name) throws Failure {
        this.checkName(name);
    }

    public boolean isForceExistingJobs() {
        return false;
    }

    public static abstract class ProjectNamingStrategyDescriptor
    extends Descriptor<ProjectNamingStrategy> {
    }

    public static final class DefaultProjectNamingStrategy
    extends ProjectNamingStrategy
    implements Serializable {
        private static final long serialVersionUID = 1L;

        @DataBoundConstructor
        public DefaultProjectNamingStrategy() {
        }

        @Override
        public void checkName(String origName) throws Failure {
        }

        private Object readResolve() {
            return DEFAULT_NAMING_STRATEGY;
        }

        @Extension
        @Symbol(value={"standard"})
        public static final class DescriptorImpl
        extends ProjectNamingStrategyDescriptor {
            @Override
            @NonNull
            public String getDisplayName() {
                return Messages.DefaultProjectNamingStrategy_DisplayName();
            }

            @Override
            public String getHelpFile() {
                return "/help/system-config/defaultJobNamingStrategy.html";
            }
        }
    }

    public static final class PatternProjectNamingStrategy
    extends ProjectNamingStrategy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String namePattern;
        private final String description;
        private boolean forceExistingJobs;

        @Deprecated
        public PatternProjectNamingStrategy(String namePattern, boolean forceExistingJobs) {
            this(namePattern, null, forceExistingJobs);
        }

        @DataBoundConstructor
        public PatternProjectNamingStrategy(String namePattern, String description, boolean forceExistingJobs) {
            this.namePattern = namePattern;
            this.description = description;
            this.forceExistingJobs = forceExistingJobs;
        }

        @Override
        public void checkName(String name) {
            if (!(this.namePattern == null || this.namePattern.isBlank() || name == null || name.isBlank() || Pattern.matches(this.namePattern, name))) {
                throw new Failure(this.description == null || this.description.isEmpty() ? Messages.Hudson_JobNameConventionNotApplyed(name, this.namePattern) : this.description);
            }
        }

        public String getNamePattern() {
            return this.namePattern;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isForceExistingJobs() {
            return this.forceExistingJobs;
        }

        @Extension
        @Symbol(value={"pattern"})
        public static final class DescriptorImpl
        extends ProjectNamingStrategyDescriptor {
            public static final String DEFAULT_PATTERN = ".*";

            @Override
            @NonNull
            public String getDisplayName() {
                return Messages.PatternProjectNamingStrategy_DisplayName();
            }

            @Override
            public String getHelpFile() {
                return "/help/system-config/patternJobNamingStrategy.html";
            }

            public FormValidation doCheckNamePattern(@QueryParameter String value) throws IOException, ServletException {
                String pattern = Util.fixEmptyAndTrim(value);
                if (pattern == null) {
                    return FormValidation.error(Messages.PatternProjectNamingStrategy_NamePatternRequired());
                }
                try {
                    Pattern.compile(pattern);
                }
                catch (PatternSyntaxException e) {
                    return FormValidation.error(Messages.PatternProjectNamingStrategy_NamePatternInvalidSyntax());
                }
                return FormValidation.ok();
            }
        }
    }
}

