/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.security.ACL;
import hudson.util.HttpResponses;
import hudson.util.Secret;
import java.io.IOException;
import java.security.SecureRandom;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.security.HMACConfidentialKey;
import jenkins.security.Messages;
import jenkins.security.apitoken.ApiTokenPropertyConfiguration;
import jenkins.security.apitoken.ApiTokenStats;
import jenkins.security.apitoken.ApiTokenStore;
import jenkins.security.apitoken.TokenUuidAndPlainValue;
import jenkins.util.SystemProperties;
import net.jcip.annotations.Immutable;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ApiTokenProperty
extends UserProperty {
    private static final Logger LOGGER = Logger.getLogger(ApiTokenProperty.class.getName());
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Accessible via System Groovy Scripts")
    private static boolean SHOW_LEGACY_TOKEN_TO_ADMINS = SystemProperties.getBoolean(ApiTokenProperty.class.getName() + ".showTokenToAdmins");
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Accessible via System Groovy Scripts")
    private static boolean ADMIN_CAN_GENERATE_NEW_TOKENS = SystemProperties.getBoolean(ApiTokenProperty.class.getName() + ".adminCanGenerateNewTokens");
    private volatile Secret apiToken;
    private ApiTokenStore tokenStore;
    private transient ApiTokenStats tokenStats;
    @Deprecated
    private static final SecureRandom RANDOM = new SecureRandom();
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public static final HMACConfidentialKey API_KEY_SEED = new HMACConfidentialKey(ApiTokenProperty.class, "seed", 16);

    @DataBoundConstructor
    public ApiTokenProperty() {
    }

    @Override
    protected void setUser(User u) {
        super.setUser(u);
        if (this.tokenStore == null) {
            this.tokenStore = new ApiTokenStore();
        }
        if (this.tokenStats == null) {
            this.tokenStats = ApiTokenStats.load(this.user);
        }
        if (this.apiToken != null) {
            this.tokenStore.regenerateTokenFromLegacyIfRequired(this.apiToken);
        }
    }

    ApiTokenProperty(@CheckForNull String seed) {
        if (seed != null) {
            this.apiToken = Secret.fromString(seed);
        }
    }

    @NonNull
    public String getApiToken() {
        LOGGER.log(Level.FINE, "Deprecated usage of getApiToken");
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "Deprecated usage of getApiToken (trace)", new Exception());
        }
        return this.hasPermissionToSeeToken() ? this.getApiTokenInsecure() : Messages.ApiTokenProperty_ChangeToken_TokenIsHidden();
    }

    @Restricted(value={NoExternalUse.class})
    public boolean hasLegacyToken() {
        return this.apiToken != null;
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    @SuppressFBWarnings(value={"UNSAFE_HASH_EQUALS"}, justification="Used to prevent use of pre-2013 API tokens, then returning the API token value")
    String getApiTokenInsecure() {
        if (this.apiToken == null) {
            return Messages.ApiTokenProperty_NoLegacyToken();
        }
        String p = this.apiToken.getPlainText();
        if (p.equals(Util.getDigestOf(Jenkins.get().getSecretKey() + ":" + this.user.getId()))) {
            p = API_KEY_SEED.mac(this.user.getId());
            this.apiToken = Secret.fromString(p);
        }
        return Util.getDigestOf(p);
    }

    public boolean matchesPassword(String token) {
        if (token == null || token.isBlank()) {
            return false;
        }
        ApiTokenStore.HashedToken matchingToken = this.tokenStore.findMatchingToken(token);
        if (matchingToken == null) {
            return false;
        }
        this.tokenStats.updateUsageForId(matchingToken.getUuid());
        return true;
    }

    private boolean hasPermissionToSeeToken() {
        return ApiTokenProperty.canCurrentUserControlObject(SHOW_LEGACY_TOKEN_TO_ADMINS, this.user);
    }

    private static boolean canCurrentUserControlObject(boolean trustAdmins, User propertyOwner) {
        if (trustAdmins && Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            return true;
        }
        User current = User.current();
        if (current == null) {
            return false;
        }
        if (Jenkins.getAuthentication2().equals(ACL.SYSTEM2)) {
            return true;
        }
        return User.idStrategy().equals(propertyOwner.getId(), current.getId());
    }

    @Restricted(value={NoExternalUse.class})
    public Collection<TokenInfoAndStats> getTokenList() {
        return this.tokenStore.getTokenListSortedByName().stream().map(token -> {
            ApiTokenStats.SingleTokenStats stats = this.tokenStats.findTokenStatsById(token.getUuid());
            return new TokenInfoAndStats((ApiTokenStore.HashedToken)token, stats);
        }).collect(Collectors.toList());
    }

    @Override
    public UserProperty reconfigure(StaplerRequest req, @CheckForNull JSONObject form) throws Descriptor.FormException {
        if (form == null) {
            return this;
        }
        Object tokenStoreData = form.get("tokenStore");
        Map<String, JSONObject> tokenStoreTypedData = this.convertToTokenMap(tokenStoreData);
        this.tokenStore.reconfigure(tokenStoreTypedData);
        return this;
    }

    private Map<String, JSONObject> convertToTokenMap(Object tokenStoreData) {
        if (tokenStoreData == null) {
            return Collections.emptyMap();
        }
        if (tokenStoreData instanceof JSONObject) {
            JSONObject singleTokenData = (JSONObject)tokenStoreData;
            HashMap<String, JSONObject> result = new HashMap<String, JSONObject>();
            this.addJSONTokenIntoMap(result, singleTokenData);
            return result;
        }
        if (tokenStoreData instanceof JSONArray) {
            JSONArray tokenArray = (JSONArray)tokenStoreData;
            HashMap<String, JSONObject> result = new HashMap<String, JSONObject>();
            for (int i = 0; i < tokenArray.size(); ++i) {
                JSONObject tokenData = tokenArray.getJSONObject(i);
                this.addJSONTokenIntoMap(result, tokenData);
            }
            return result;
        }
        throw HttpResponses.error((int)400, (String)"Unexpected class received for the token store information");
    }

    private void addJSONTokenIntoMap(Map<String, JSONObject> tokenMap, JSONObject tokenData) {
        String uuid = tokenData.getString("tokenUuid");
        tokenMap.put(uuid, tokenData);
    }

    @Deprecated
    public void changeApiToken() throws IOException {
        this.user.checkPermission(Jenkins.ADMINISTER);
        LOGGER.log(Level.FINE, "Deprecated usage of changeApiToken");
        ApiTokenStore.HashedToken existingLegacyToken = this.tokenStore.getLegacyToken();
        this._changeApiToken();
        this.tokenStore.regenerateTokenFromLegacy(this.apiToken);
        if (existingLegacyToken != null) {
            this.tokenStats.removeId(existingLegacyToken.getUuid());
        }
        this.user.save();
    }

    @Deprecated
    private void _changeApiToken() {
        byte[] random = new byte[16];
        RANDOM.nextBytes(random);
        this.apiToken = Secret.fromString(Util.toHexString(random));
    }

    @Restricted(value={NoExternalUse.class})
    public void deleteApiToken() {
        this.apiToken = null;
    }

    @Restricted(value={NoExternalUse.class})
    public ApiTokenStore getTokenStore() {
        return this.tokenStore;
    }

    @Restricted(value={NoExternalUse.class})
    public ApiTokenStats getTokenStats() {
        return this.tokenStats;
    }

    @Restricted(value={Beta.class})
    @NonNull
    public String addFixedNewToken(@NonNull String name, @NonNull String tokenPlainValue) throws IOException {
        String tokenUuid = this.tokenStore.addFixedNewToken(name, tokenPlainValue);
        this.user.save();
        return tokenUuid;
    }

    @Restricted(value={Beta.class})
    @NonNull
    public TokenUuidAndPlainValue generateNewToken(@NonNull String name) throws IOException {
        TokenUuidAndPlainValue tokenUuidAndPlainValue = this.tokenStore.generateNewToken(name);
        this.user.save();
        return tokenUuidAndPlainValue;
    }

    @Restricted(value={Beta.class})
    public void revokeAllTokens() throws IOException {
        this.tokenStats.removeAll();
        this.tokenStore.revokeAllTokens();
        this.user.save();
    }

    @Restricted(value={Beta.class})
    public void revokeAllTokensExceptOne(@NonNull String tokenUuid) throws IOException {
        this.tokenStats.removeAllExcept(tokenUuid);
        this.tokenStore.revokeAllTokensExcept(tokenUuid);
        this.user.save();
    }

    @Restricted(value={Beta.class})
    public void revokeToken(@NonNull String tokenUuid) throws IOException {
        ApiTokenStore.HashedToken revoked = this.tokenStore.revokeToken(tokenUuid);
        if (revoked != null) {
            if (revoked.isLegacy()) {
                this.apiToken = null;
            }
            this.tokenStats.removeId(revoked.getUuid());
            this.user.save();
        }
    }

    @Immutable
    @Restricted(value={NoExternalUse.class})
    public static class TokenInfoAndStats {
        public final String uuid;
        public final String name;
        public final Date creationDate;
        public final long numDaysCreation;
        public final boolean isLegacy;
        public final int useCounter;
        public final Date lastUseDate;
        public final long numDaysUse;

        public TokenInfoAndStats(@NonNull ApiTokenStore.HashedToken token, @NonNull ApiTokenStats.SingleTokenStats stats) {
            this.uuid = token.getUuid();
            this.name = token.getName();
            this.creationDate = token.getCreationDate();
            this.numDaysCreation = token.getNumDaysCreation();
            this.isLegacy = token.isLegacy();
            this.useCounter = stats.getUseCounter();
            this.lastUseDate = stats.getLastUseDate();
            this.numDaysUse = stats.getNumDaysUse();
        }
    }

    @Extension
    @Symbol(value={"apiToken"})
    public static final class DescriptorImpl
    extends UserPropertyDescriptor {
        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.ApiTokenProperty_DisplayName();
        }

        @Restricted(value={NoExternalUse.class})
        public String getNoLegacyToken() {
            return Messages.ApiTokenProperty_NoLegacyToken();
        }

        @Override
        public ApiTokenProperty newInstance(User user) {
            if (!ApiTokenPropertyConfiguration.get().isTokenGenerationOnCreationEnabled()) {
                return this.forceNewInstance(user, false);
            }
            return this.forceNewInstance(user, true);
        }

        private ApiTokenProperty forceNewInstance(User user, boolean withLegacyToken) {
            if (withLegacyToken) {
                return new ApiTokenProperty(API_KEY_SEED.mac(user.getId()));
            }
            return new ApiTokenProperty(null);
        }

        @Restricted(value={NoExternalUse.class})
        public boolean isStatisticsEnabled() {
            return ApiTokenPropertyConfiguration.get().isUsageStatisticsEnabled();
        }

        @Restricted(value={NoExternalUse.class})
        public boolean mustDisplayLegacyApiToken(User propertyOwner) {
            ApiTokenProperty property = propertyOwner.getProperty(ApiTokenProperty.class);
            if (property != null && property.apiToken != null) {
                return true;
            }
            return ApiTokenPropertyConfiguration.get().isCreationOfLegacyTokenEnabled();
        }

        @Restricted(value={NoExternalUse.class})
        public boolean hasCurrentUserRightToGenerateNewToken(User propertyOwner) {
            return ApiTokenProperty.canCurrentUserControlObject(ADMIN_CAN_GENERATE_NEW_TOKENS, propertyOwner);
        }

        @Deprecated
        @RequirePOST
        public HttpResponse doChangeToken(@AncestorInPath User u, StaplerResponse rsp) throws IOException {
            u.checkPermission(Jenkins.ADMINISTER);
            LOGGER.log(Level.FINE, "Deprecated action /changeToken used, consider using /generateNewToken instead");
            if (!this.mustDisplayLegacyApiToken(u)) {
                return HttpResponses.html((String)Messages.ApiTokenProperty_ChangeToken_CapabilityNotAllowed());
            }
            ApiTokenProperty p = u.getProperty(ApiTokenProperty.class);
            if (p == null) {
                p = this.forceNewInstance(u, true);
                p.setUser(u);
                u.addProperty(p);
            } else {
                p.changeApiToken();
            }
            rsp.setHeader("script", "document.getElementById('apiToken').value='" + p.getApiToken() + "'");
            return HttpResponses.html((String)(p.hasPermissionToSeeToken() ? Messages.ApiTokenProperty_ChangeToken_Success() : Messages.ApiTokenProperty_ChangeToken_SuccessHidden()));
        }

        @RequirePOST
        public HttpResponse doGenerateNewToken(@AncestorInPath User u, @QueryParameter String newTokenName) throws IOException {
            if (!this.hasCurrentUserRightToGenerateNewToken(u)) {
                return HttpResponses.forbidden();
            }
            String tokenName = newTokenName == null || newTokenName.isBlank() ? Messages.Token_Created_on(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.now())) : newTokenName;
            ApiTokenProperty p = u.getProperty(ApiTokenProperty.class);
            if (p == null) {
                p = this.forceNewInstance(u, false);
                u.addProperty(p);
            }
            TokenUuidAndPlainValue tokenUuidAndPlainValue = p.generateNewToken(tokenName);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("tokenUuid", tokenUuidAndPlainValue.tokenUuid);
            data.put("tokenName", tokenName);
            data.put("tokenValue", tokenUuidAndPlainValue.plainValue);
            return HttpResponses.okJSON(data);
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public HttpResponse doAddFixedToken(@AncestorInPath User u, @QueryParameter String newTokenName, @QueryParameter String newTokenPlainValue) throws IOException {
            if (!this.hasCurrentUserRightToGenerateNewToken(u)) {
                return HttpResponses.forbidden();
            }
            String tokenName = newTokenName == null || newTokenName.isBlank() ? String.format("Token created on %s", DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.now())) : newTokenName;
            ApiTokenProperty p = u.getProperty(ApiTokenProperty.class);
            if (p == null) {
                p = this.forceNewInstance(u, false);
                u.addProperty(p);
            }
            String tokenUuid = p.tokenStore.addFixedNewToken(tokenName, newTokenPlainValue);
            u.save();
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("tokenUuid", tokenUuid);
            data.put("tokenName", tokenName);
            return HttpResponses.okJSON(data);
        }

        @RequirePOST
        public HttpResponse doRename(@AncestorInPath User u, @QueryParameter String tokenUuid, @QueryParameter String newName) throws IOException {
            u.checkPermission(Jenkins.ADMINISTER);
            if (newName == null || newName.isBlank()) {
                return HttpResponses.errorJSON("The name cannot be empty");
            }
            if (tokenUuid == null || tokenUuid.isBlank()) {
                return HttpResponses.errorWithoutStack((int)400, (String)"The tokenUuid cannot be empty");
            }
            ApiTokenProperty p = u.getProperty(ApiTokenProperty.class);
            if (p == null) {
                return HttpResponses.errorWithoutStack((int)400, (String)"The user does not have any ApiToken yet, try generating one before.");
            }
            boolean renameOk = p.tokenStore.renameToken(tokenUuid, newName);
            if (!renameOk) {
                return HttpResponses.errorJSON("No token found, try refreshing the page");
            }
            u.save();
            return HttpResponses.ok();
        }

        @RequirePOST
        public HttpResponse doRevoke(@AncestorInPath User u, @QueryParameter String tokenUuid) throws IOException {
            u.checkPermission(Jenkins.ADMINISTER);
            if (tokenUuid == null || tokenUuid.isBlank()) {
                return HttpResponses.errorWithoutStack((int)400, (String)"The tokenUuid cannot be empty");
            }
            ApiTokenProperty p = u.getProperty(ApiTokenProperty.class);
            if (p == null) {
                return HttpResponses.errorWithoutStack((int)400, (String)"The user does not have any ApiToken yet, try generating one before.");
            }
            p.revokeToken(tokenUuid);
            return HttpResponses.ok();
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public HttpResponse doRevokeAll(@AncestorInPath User u) throws IOException {
            u.checkPermission(Jenkins.ADMINISTER);
            ApiTokenProperty p = u.getProperty(ApiTokenProperty.class);
            if (p == null) {
                return HttpResponses.errorWithoutStack((int)400, (String)"The user does not have any ApiToken yet, try generating one before.");
            }
            p.revokeAllTokens();
            return HttpResponses.ok();
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public HttpResponse doRevokeAllExcept(@AncestorInPath User u, @QueryParameter String tokenUuid) throws IOException {
            u.checkPermission(Jenkins.ADMINISTER);
            if (tokenUuid == null || tokenUuid.isBlank()) {
                return HttpResponses.errorWithoutStack((int)400, (String)"The tokenUuid cannot be empty");
            }
            ApiTokenProperty p = u.getProperty(ApiTokenProperty.class);
            if (p == null) {
                return HttpResponses.errorWithoutStack((int)400, (String)"The user does not have any ApiToken yet, try generating one before.");
            }
            p.revokeAllTokensExceptOne(tokenUuid);
            return HttpResponses.ok();
        }
    }
}

