/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.util.Secret;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import jenkins.security.ConfidentialKey;
import jenkins.security.ConfidentialStore;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class CryptoConfidentialKey
extends ConfidentialKey {
    @Restricted(value={NoExternalUse.class})
    public static final int DEFAULT_IV_LENGTH = 16;
    private ConfidentialStore lastCS;
    private SecretKey secret;
    private static final String KEY_ALGORITHM = "AES";
    private static final String ALGORITHM = "AES/CBC/PKCS5Padding";

    public CryptoConfidentialKey(String id) {
        super(id);
    }

    public CryptoConfidentialKey(Class owner, String shortName) {
        this(owner.getName() + "." + shortName);
    }

    private synchronized SecretKey getKey() {
        ConfidentialStore cs = ConfidentialStore.get();
        if (this.secret == null || cs != this.lastCS) {
            this.lastCS = cs;
            try {
                byte[] payload = this.load();
                if (payload == null) {
                    payload = cs.randomBytes(256);
                    this.store(payload);
                }
                this.secret = new SecretKeySpec(payload, 0, 16, KEY_ALGORITHM);
            }
            catch (IOException e) {
                throw new Error("Failed to load the key: " + this.getId(), e);
            }
        }
        return this.secret;
    }

    @Deprecated
    public Cipher encrypt() {
        try {
            Cipher cipher = Secret.getCipher(KEY_ALGORITHM);
            cipher.init(1, this.getKey());
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public Cipher encrypt(byte[] iv) {
        try {
            Cipher cipher = Secret.getCipher(ALGORITHM);
            cipher.init(1, (Key)this.getKey(), new IvParameterSpec(iv));
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public Cipher decrypt(byte[] iv) {
        try {
            Cipher cipher = Secret.getCipher(ALGORITHM);
            cipher.init(2, (Key)this.getKey(), new IvParameterSpec(iv));
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public byte[] newIv(int length) {
        return ConfidentialStore.get().randomBytes(length);
    }

    @Restricted(value={NoExternalUse.class})
    public byte[] newIv() {
        return this.newIv(16);
    }

    @Deprecated
    public Cipher decrypt() {
        try {
            Cipher cipher = Secret.getCipher(KEY_ALGORITHM);
            cipher.init(2, this.getKey());
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new AssertionError((Object)e);
        }
    }
}

