/*
 * Decompiled with CFR 0.152.
 */
package jenkins.telemetry.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Node;
import hudson.slaves.Cloud;
import java.time.LocalDate;
import java.util.HashMap;
import jenkins.diagnostics.ControllerExecutorsAgents;
import jenkins.diagnostics.ControllerExecutorsNoAgents;
import jenkins.model.Jenkins;
import jenkins.telemetry.Telemetry;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@Extension
public class DistributedBuilds
extends Telemetry {
    @Override
    @NonNull
    public String getDisplayName() {
        return "Distributed Builds";
    }

    @Override
    @NonNull
    public LocalDate getStart() {
        return LocalDate.of(2022, 12, 1);
    }

    @Override
    @NonNull
    public LocalDate getEnd() {
        return LocalDate.of(2023, 3, 1);
    }

    @Override
    public JSONObject createContent() {
        JSONObject payload = new JSONObject();
        payload.put("controllerExecutors", (Object)Jenkins.get().getNumExecutors());
        payload.put("controllerExecutorsWithAgentsWarning", (Object)ExtensionList.lookupSingleton(ControllerExecutorsAgents.class).isEnabled());
        payload.put("controllerExecutorsWithoutAgentsWarning", (Object)ExtensionList.lookupSingleton(ControllerExecutorsNoAgents.class).isEnabled());
        HashMap<String, Integer> clouds = new HashMap<String, Integer>();
        for (Cloud cloud : Jenkins.get().clouds) {
            clouds.compute(cloud.getClass().getName(), (key, value) -> value == null ? 1 : value + 1);
        }
        payload.put("clouds", clouds);
        HashMap<String, Integer> agents = new HashMap<String, Integer>();
        for (Node agent : Jenkins.get().getNodes()) {
            agents.compute(agent.getClass().getName(), (key, value) -> value == null ? 1 : value + 1);
        }
        payload.put("agents", agents);
        payload.put("items", (Object)Jenkins.get().getAllItems().size());
        payload.put("components", this.buildComponentInformation());
        return payload;
    }
}

