/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.init.Initializer;
import hudson.util.PluginServletFilter;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

public interface HttpServletFilter
extends ExtensionPoint {
    public boolean handle(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ServletException;

    @Restricted(value={DoNotUse.class})
    @Initializer
    public static void register() throws ServletException {
        PluginServletFilter.addFilter(new Filter(){

            public void doFilter(ServletRequest req, ServletResponse rsp, FilterChain chain) throws IOException, ServletException {
                if (req instanceof HttpServletRequest && rsp instanceof HttpServletResponse) {
                    for (HttpServletFilter filter : ExtensionList.lookup(HttpServletFilter.class)) {
                        if (!filter.handle((HttpServletRequest)req, (HttpServletResponse)rsp)) continue;
                        return;
                    }
                }
                chain.doFilter(req, rsp);
            }

            public void init(FilterConfig filterConfig) {
            }

            public void destroy() {
            }
        });
    }
}

