/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.lang.annotation.Annotation;
import javax.servlet.ServletException;
import org.apache.commons.beanutils.Converter;
import org.kohsuke.stapler.InjectedParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public abstract class AnnotationHandler<T extends Annotation> {
    private static final ClassValue<AnnotationHandler> HANDLERS = new ClassValue<AnnotationHandler>(){

        @Override
        protected AnnotationHandler computeValue(Class<?> at) {
            InjectedParameter ip = at.getAnnotation(InjectedParameter.class);
            if (ip != null) {
                try {
                    return ip.value().newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException("Failed to instantiate parameter injector for " + at, e);
                }
            }
            return NOT_HANDLER;
        }
    };
    private static final AnnotationHandler NOT_HANDLER = new AnnotationHandler(){

        public Object parse(StaplerRequest request, Annotation a, Class type, String parameterName) throws ServletException {
            return null;
        }
    };

    public abstract Object parse(StaplerRequest var1, T var2, Class var3, String var4) throws ServletException;

    protected final Object convert(Class targetType, String value) {
        Converter converter = Stapler.lookupConverter(targetType);
        if (converter == null) {
            throw new IllegalArgumentException("Unable to convert to " + targetType);
        }
        return converter.convert(targetType, (Object)value);
    }

    static Object handle(StaplerRequest request, Annotation[] annotations, String parameterName, Class targetType) throws ServletException {
        for (Annotation a : annotations) {
            Class<? extends Annotation> at = a.annotationType();
            AnnotationHandler h = HANDLERS.get(at);
            if (h == NOT_HANDLER) continue;
            return h.parse(request, a, targetType, parameterName);
        }
        return null;
    }
}

