/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.kohsuke.stapler.MetaClass;

public abstract class CachingScriptLoader<S, E extends Exception> {
    private final Map<String, Optional<Reference<S>>> scripts = new ConcurrentHashMap<String, Optional<Reference<S>>>();

    public S findScript(String name) throws E {
        Object s;
        if (MetaClass.NO_CACHE) {
            return this.loadScript(name);
        }
        Optional<Reference<S>> sr = this.scripts.get(name);
        if (sr == null) {
            s = null;
        } else {
            if (!sr.isPresent()) {
                return null;
            }
            s = sr.get().get();
        }
        if (s == null) {
            s = this.loadScript(name);
            this.scripts.put(name, s == null ? Optional.empty() : Optional.of(new SoftReference<Object>(s)));
        }
        return (S)s;
    }

    protected abstract S loadScript(String var1) throws E;

    public void clearScripts() {
        this.scripts.clear();
    }

    protected abstract URL getResource(String var1);
}

