/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.ResponseImpl;

class DirectoryishDispatcher
extends Dispatcher {
    private static final Logger LOGGER = Logger.getLogger(DirectoryishDispatcher.class.getName());

    DirectoryishDispatcher() {
    }

    @Override
    public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
        String servletPath;
        if (!req.tokens.hasMore() && !(servletPath = req.stapler.getServletPath(req)).endsWith("/")) {
            String target = req.getContextPath() + servletPath + "/";
            if (req.getQueryString() != null) {
                target = target + "?" + req.getQueryString();
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Redirecting to " + target);
            }
            rsp.sendRedirect2(target);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "If path ends without '/' insert it";
    }
}

