/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.kohsuke.stapler.CancelRequestHandlingException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public interface DispatchValidator {
    public static final DispatchValidator DEFAULT = new DispatchValidator(){

        @Override
        public Boolean isDispatchAllowed(@NonNull StaplerRequest req, @NonNull StaplerResponse rsp) {
            return true;
        }

        @Override
        public void allowDispatch(@NonNull StaplerRequest req, @NonNull StaplerResponse rsp) {
        }
    };

    @CheckForNull
    public Boolean isDispatchAllowed(@NonNull StaplerRequest var1, @NonNull StaplerResponse var2);

    @CheckForNull
    default public Boolean isDispatchAllowed(@NonNull StaplerRequest req, @NonNull StaplerResponse rsp, @NonNull String viewName, @CheckForNull Object node) {
        return this.isDispatchAllowed(req, rsp);
    }

    public void allowDispatch(@NonNull StaplerRequest var1, @NonNull StaplerResponse var2);

    default public void requireDispatchAllowed(@NonNull StaplerRequest req, @NonNull StaplerResponse rsp) throws CancelRequestHandlingException {
        Boolean allowed = this.isDispatchAllowed(req, rsp);
        if (allowed == null || !allowed.booleanValue()) {
            throw new CancelRequestHandlingException();
        }
    }
}

