/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.JSONUtils;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Flavor;

public abstract class HttpResponseRenderer {
    private static final Logger LOGGER = Logger.getLogger(HttpResponseRenderer.class.getName());

    public abstract boolean generateResponse(StaplerRequest var1, StaplerResponse var2, Object var3, Object var4) throws IOException, ServletException;

    static String quote(String text) {
        return JSONUtils.quote((String)text);
    }

    public static class Default
    extends HttpResponseRenderer {
        @Override
        public boolean generateResponse(StaplerRequest req, StaplerResponse rsp, Object node, Object response) throws IOException, ServletException {
            return this.handleHttpResponse(req, rsp, node, response) || this.handleJSON(rsp, response) || this.handleJavaScriptProxyMethodCall(req, rsp, response) || this.handlePrimitive(rsp, response);
        }

        protected boolean handleJavaScriptProxyMethodCall(StaplerRequest req, StaplerResponse rsp, Object response) throws IOException {
            if (req.isJavaScriptProxyCall()) {
                rsp.setContentType(Flavor.JSON.contentType);
                PrintWriter w = rsp.getWriter();
                try {
                    if (response instanceof String) {
                        w.print(Default.quote((String)response));
                    } else if (response instanceof Number || response instanceof Boolean) {
                        w.print(response);
                    } else if (response instanceof Collection || response != null && response.getClass().isArray()) {
                        JSONArray.fromObject((Object)response, (JsonConfig)rsp.getJsonConfig()).write((Writer)w);
                    } else if (response == null) {
                        JSONNull.getInstance().write((Writer)w);
                    } else {
                        if (response instanceof Throwable) {
                            LOGGER.log(Level.WARNING, "call to " + req.getRequestURI() + " failed", (Throwable)response);
                            return false;
                        }
                        JSONObject.fromObject((Object)response, (JsonConfig)rsp.getJsonConfig()).write((Writer)w);
                    }
                }
                catch (JSONException x) {
                    LOGGER.log(Level.WARNING, "failed to serialize " + response + " for " + req.getRequestURI() + " given " + req.getAncestors(), x);
                    return false;
                }
                return true;
            }
            return false;
        }

        protected boolean handlePrimitive(StaplerResponse rsp, Object response) throws IOException {
            if (response instanceof String || response instanceof Integer) {
                rsp.setContentType("text/plain;charset=UTF-8");
                rsp.getWriter().print(response);
                return true;
            }
            return false;
        }

        protected boolean handleHttpResponse(StaplerRequest req, StaplerResponse rsp, Object node, Object response) throws IOException, ServletException {
            if (response instanceof HttpResponse) {
                block3: {
                    HttpResponse r = (HttpResponse)response;
                    try {
                        r.generateResponse(req, rsp, node);
                    }
                    catch (IOException | RuntimeException | ServletException e) {
                        if (this.handleHttpResponse(req, rsp, node, e)) break block3;
                        throw e;
                    }
                }
                return true;
            }
            return false;
        }

        protected boolean handleJSON(StaplerResponse rsp, Object response) throws IOException {
            if (response instanceof JSON) {
                rsp.setContentType(Flavor.JSON.contentType);
                ((JSON)response).write((Writer)rsp.getWriter());
                return true;
            }
            return false;
        }
    }
}

