/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;

public final class TokenList {
    public final String[] tokens;
    public final String[] rawTokens;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility")
    public int idx;
    public final boolean endsWithSlash;

    TokenList(String url) {
        StringTokenizer tknzr = new StringTokenizer(url, "/\\");
        int tokenCount = tknzr.countTokens();
        this.tokens = new String[tokenCount];
        this.rawTokens = new String[tokenCount];
        int i = 0;
        while (tknzr.hasMoreTokens()) {
            this.rawTokens[i] = tknzr.nextToken();
            this.tokens[i] = TokenList.decode(this.rawTokens[i]);
            if (this.tokens[i].equals("..")) {
                throw new IllegalArgumentException(url);
            }
            ++i;
        }
        this.endsWithSlash = url.endsWith("/") || url.endsWith("\\");
    }

    public boolean hasMore() {
        return this.tokens.length != this.idx;
    }

    public String peek() {
        if (this.hasMore()) {
            return this.tokens[this.idx];
        }
        return null;
    }

    public String next() {
        return this.tokens[this.idx++];
    }

    public String prev() {
        return this.tokens[--this.idx];
    }

    public int nextAsInt() throws NumberFormatException {
        long asLongValue = this.nextAsLong();
        if (asLongValue < Integer.MIN_VALUE) {
            throw new NumberFormatException(String.format("Token '%d' cannot be interpreted as an integer as its value is less than %d.", asLongValue, Integer.MIN_VALUE));
        }
        if (asLongValue > Integer.MAX_VALUE) {
            throw new NumberFormatException(String.format("Token '%d' cannot be interpreted as an integer as its value is greater than %d.", asLongValue, Integer.MAX_VALUE));
        }
        return (int)asLongValue;
    }

    public long nextAsLong() throws NumberFormatException {
        String p = this.peek();
        if (p == null) {
            throw new NumberFormatException();
        }
        long asLongValue = Long.parseLong(p);
        ++this.idx;
        return asLongValue;
    }

    public int length() {
        return this.tokens.length;
    }

    public String get(int i) {
        return this.tokens[i];
    }

    public int countRemainingTokens() {
        return this.length() - this.idx;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.tokens.length; ++i) {
            if (buf.length() > 0) {
                buf.append('/');
            }
            if (i == this.idx) {
                buf.append('!');
            }
            buf.append(this.tokens[i]);
        }
        return buf.toString();
    }

    private String assembleRestOfPath(String[] tokens) {
        StringBuilder buf = new StringBuilder();
        for (int i = this.idx; i < this.length(); ++i) {
            buf.append('/');
            buf.append(tokens[i]);
        }
        return buf.toString();
    }

    public String assembleRestOfPath() {
        return this.assembleRestOfPath(this.tokens);
    }

    public String assembleOriginalRestOfPath() {
        return this.assembleRestOfPath(this.rawTokens);
    }

    public static String decode(String s) {
        int i = s.indexOf(37);
        if (i < 0) {
            return s;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StringBuilder buf = new StringBuilder(s.substring(0, i));
        int m = s.length();
        while (i < m) {
            char c = s.charAt(i);
            if (c == '%') {
                try {
                    char upper = s.charAt(++i);
                    char lower = s.charAt(++i);
                    baos.write(TokenList.fromHex(upper) * 16 + TokenList.fromHex(lower));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            } else {
                if (baos.size() > 0) {
                    buf.append(baos.toString(StandardCharsets.UTF_8));
                    baos.reset();
                }
                buf.append(c);
            }
            ++i;
        }
        if (baos.size() > 0) {
            buf.append(baos.toString(StandardCharsets.UTF_8));
        }
        return buf.toString();
    }

    private static int fromHex(char upper) {
        return (upper & 0xF) + ((upper & 0x40) != 0 ? 9 : 0);
    }
}

