/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.bind;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerFallback;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.bind.Bound;
import org.kohsuke.stapler.bind.WithWellKnownURL;

public class BoundObjectTable
implements StaplerFallback {
    public static final String PREFIX = "/$stapler/bound/";
    static final String SCRIPT_PREFIX = "/$stapler/bound/script";
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Legacy switch.")
    public static boolean DEBUG_LOGGING = Boolean.getBoolean(BoundObjectTable.class.getName() + ".debugLog");
    private static final Logger LOGGER = Logger.getLogger(BoundObjectTable.class.getName());

    public static boolean isValidJavaScriptIdentifier(String variableName) {
        return variableName.matches("^[a-zA-Z_][a-zA-Z0-9_]*$");
    }

    public static boolean isValidJavaIdentifier(String name) {
        if (name == null || StringUtils.isBlank((String)name)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0)) || Character.codePointAt(name, 0) > 255) {
            return false;
        }
        return name.substring(1).chars().allMatch(it -> Character.isJavaIdentifierPart(it) && !Character.isIdentifierIgnorable(it) && it < 256);
    }

    public void doScript(StaplerRequest req, StaplerResponse rsp, @QueryParameter String var, @QueryParameter String methods) throws IOException {
        String script;
        String boundUrl = req.getRestOfPath();
        if (var == null) {
            return;
        }
        if (!BoundObjectTable.isValidJavaScriptIdentifier(var)) {
            LOGGER.log(Level.FINE, () -> "Rejecting invalid JavaScript identifier: " + var);
            return;
        }
        rsp.setContentType("text/javascript");
        PrintWriter writer = rsp.getWriter();
        if ("/null".equals(boundUrl)) {
            writer.append(var).append(" = null;");
            return;
        }
        String contextAndPrefix = Stapler.getCurrentRequest().getContextPath() + PREFIX;
        if (boundUrl.startsWith(contextAndPrefix)) {
            String id = boundUrl.replace(contextAndPrefix, "");
            Table table = this.resolve(false);
            if (table == null) {
                rsp.sendError(404);
                return;
            }
            Object object = table.resolve(id);
            if (object == null) {
                writer.append(var).append(" = null;");
                return;
            }
            script = Bound.getProxyScript(boundUrl, object.getClass());
        } else {
            if (methods == null) {
                return;
            }
            String[] methodsArray = methods.split(",");
            if (Arrays.stream(methodsArray).anyMatch(it -> !BoundObjectTable.isValidJavaIdentifier(it))) {
                LOGGER.log(Level.FINE, () -> "Rejecting method list that includes an invalid Java identifier: " + methods);
                return;
            }
            script = Bound.getProxyScript(boundUrl, methodsArray);
        }
        writer.append(var).append(" = ").append(script).append(";");
    }

    @Override
    public Table getStaplerFallback() {
        return this.resolve(false);
    }

    private Bound bind(Ref ref) {
        return this.resolve(true).add(ref);
    }

    public Bound bind(Object o) {
        return this.bind(new StrongRef(o));
    }

    public Bound bindWeak(Object o) {
        return this.bind(new WeakRef(o));
    }

    public void releaseMe() {
        Ancestor eot = Stapler.getCurrentRequest().findAncestor(BoundObjectTable.class);
        if (eot == null) {
            throw new IllegalStateException("The thread is not handling a request to a abound object");
        }
        String id = eot.getNextToken(0);
        this.resolve(false).release(id);
    }

    private Table resolve(boolean createIfNotExist) {
        HttpSession session = Stapler.getCurrentRequest().getSession(createIfNotExist);
        if (session == null) {
            return null;
        }
        Table t = (Table)session.getAttribute(Table.class.getName());
        if (t == null) {
            if (createIfNotExist) {
                t = new Table();
                session.setAttribute(Table.class.getName(), (Object)t);
            } else {
                return null;
            }
        }
        return t;
    }

    public Table getTable() {
        return this.resolve(true);
    }

    public static class Table
    implements Serializable {
        private final Map<String, Ref> entries = new HashMap<String, Ref>();
        private boolean logging;

        private synchronized Bound add(Ref ref) {
            final Object target = ref.get();
            if (target instanceof WithWellKnownURL) {
                WithWellKnownURL w = (WithWellKnownURL)target;
                String url = w.getWellKnownUrl();
                if (!url.startsWith("/")) {
                    LOGGER.warning("WithWellKnownURL.getWellKnownUrl must start with a slash. But we got " + url + " from " + w);
                }
                return new WellKnownObjectHandle(url, w);
            }
            final String id = UUID.randomUUID().toString();
            this.entries.put(id, ref);
            if (this.logging) {
                LOGGER.info(String.format("%s binding %s for %s", this.toString(), target, id));
            }
            return new Bound(){

                @Override
                public void release() {
                    this.release(id);
                }

                @Override
                public String getURL() {
                    return Stapler.getCurrentRequest().getContextPath() + BoundObjectTable.PREFIX + id;
                }

                @Override
                public Object getTarget() {
                    return target;
                }

                @Override
                public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                    rsp.sendRedirect2(this.getURL());
                }
            };
        }

        public Object getDynamic(String id) {
            return this.resolve(id);
        }

        private synchronized Ref release(String id) {
            return this.entries.remove(id);
        }

        private synchronized Object resolve(String id) {
            Ref e = this.entries.get(id);
            if (e == null) {
                if (this.logging) {
                    LOGGER.info(this.toString() + " doesn't have binding for " + id);
                }
                return null;
            }
            Object v = e.get();
            if (v == null) {
                if (this.logging) {
                    LOGGER.warning(this.toString() + " had binding for " + id + " but it got garbage collected");
                }
                this.entries.remove(id);
            }
            return v;
        }

        @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="This usage does not create synchronization problems.")
        public HttpResponse doEnableLogging() {
            if (DEBUG_LOGGING) {
                this.logging = true;
                return HttpResponses.text("Logging enabled for this session: " + this + "\n");
            }
            return HttpResponses.forbidden();
        }
    }

    static interface Ref
    extends Serializable {
        public Object get();
    }

    private static class StrongRef
    implements Ref {
        private final Object o;

        StrongRef(Object o) {
            this.o = o;
        }

        @Override
        public Object get() {
            return this.o;
        }

        private Object writeReplace() {
            if (this.o instanceof Serializable) {
                return this;
            }
            LOGGER.fine(() -> "Refusing to serialize " + this.o);
            return new StrongRef(null);
        }
    }

    private static class WeakRef
    extends WeakReference
    implements Ref {
        private WeakRef(Object referent) {
            super(referent);
        }

        private Object writeReplace() {
            Object o = this.get();
            if (o instanceof Serializable) {
                return this;
            }
            LOGGER.fine(() -> "Refusing to serialize " + o);
            return new WeakRef((Object)null);
        }
    }

    private static final class WellKnownObjectHandle
    extends Bound {
        private final String url;
        private final Object target;

        WellKnownObjectHandle(String url, Object target) {
            this.url = url;
            this.target = target;
        }

        @Override
        public void release() {
        }

        @Override
        public String getURL() {
            return Stapler.getCurrentRequest().getContextPath() + this.url;
        }

        @Override
        public Object getTarget() {
            return this.target;
        }

        @Override
        public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
            rsp.sendRedirect2(this.getURL());
        }
    }
}

