/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.compression;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;

public class FilterServletOutputStream
extends ServletOutputStream {
    private final OutputStream out;
    private final ServletOutputStream realSream;
    private volatile boolean closed;
    private final Object closeLock = new Object();

    public FilterServletOutputStream(OutputStream out, ServletOutputStream realStream) {
        this.out = out;
        this.realSream = realStream;
    }

    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        Throwable flushException = null;
        try {
            this.flush();
        }
        catch (Throwable e) {
            flushException = e;
            throw e;
        }
        finally {
            if (flushException == null) {
                this.out.close();
            } else {
                try {
                    this.out.close();
                }
                catch (Throwable closeException) {
                    if (flushException != closeException) {
                        closeException.addSuppressed(flushException);
                    }
                    throw closeException;
                }
            }
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public boolean isReady() {
        return this.realSream.isReady();
    }

    public void setWriteListener(WriteListener writeListener) {
        this.realSream.setWriteListener(writeListener);
    }
}

