/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.export;

import java.util.Iterator;
import java.util.NoSuchElementException;

final class Iterators {
    private Iterators() {
    }

    static <T> Iterator<T> limit(final Iterator<T> iterator, final int limitSize) {
        if (iterator == null) {
            throw new NullPointerException();
        }
        if (limitSize < 0) {
            throw new IllegalArgumentException("limit is negative");
        }
        return new Iterator<T>(){
            private int count;

            @Override
            public boolean hasNext() {
                return this.count < limitSize && iterator.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.count;
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }
}

