/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.framework;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jvnet.localizer.LocaleProvider;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.framework.errors.NoHomeDirError;

public abstract class AbstractWebAppMain<T>
implements ServletContextListener {
    protected final Class<T> rootType;
    private static final String APP = "app";
    protected ServletContext context;
    protected File home;
    private CompletableFuture<Object> initializer = new CompletableFuture();
    private static final Logger LOGGER = Logger.getLogger(AbstractWebAppMain.class.getName());

    protected AbstractWebAppMain(Class<T> rootType) {
        this.rootType = rootType;
    }

    protected abstract String getApplicationName();

    protected Object createPlaceHolderForAsyncLoad() {
        return null;
    }

    protected abstract Object createApplication() throws Exception;

    public void contextInitialized(ServletContextEvent event) {
        try {
            this.context = event.getServletContext();
            this.installLocaleProvider();
            if (!this.checkEnvironment()) {
                return;
            }
            Object ph = this.createPlaceHolderForAsyncLoad();
            if (ph != null) {
                this.context.setAttribute(APP, ph);
                new Thread(this.getApplicationName() + " initialization thread"){

                    @Override
                    public void run() {
                        AbstractWebAppMain.this.setApplicationObject();
                    }
                }.start();
            } else {
                this.setApplicationObject();
            }
        }
        catch (Error | RuntimeException e) {
            LOGGER.log(Level.SEVERE, "Failed to initialize " + this.getApplicationName(), e);
            throw e;
        }
    }

    protected void setApplicationObject() {
        try {
            Object app = this.createApplication();
            this.context.setAttribute(APP, app);
            this.initializer.complete(app);
        }
        catch (Error | RuntimeException e) {
            LOGGER.log(Level.SEVERE, "Failed to initialize " + this.getApplicationName(), e);
            this.initializer.completeExceptionally(e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to initialize " + this.getApplicationName(), e);
            this.initializer.completeExceptionally(e);
            throw new Error(e);
        }
        finally {
            if (!this.initializer.isDone()) {
                this.initializer.cancel(true);
            }
        }
    }

    public Future<Object> getInitializer() {
        return this.initializer;
    }

    public Object getApplication() {
        return this.context.getAttribute(APP);
    }

    protected boolean checkEnvironment() {
        this.home = this.getHomeDir().getAbsoluteFile();
        try {
            Files.createDirectories(this.home.toPath(), new FileAttribute[0]);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Failed to create home directory: " + this.home, ioe);
            return false;
        }
        LOGGER.info(this.getApplicationName() + " home directory: " + this.home);
        if (!this.home.exists()) {
            this.context.setAttribute(APP, (Object)new NoHomeDirError(this.home));
            return false;
        }
        return true;
    }

    private void installLocaleProvider() {
        LocaleProvider.setProvider((LocaleProvider)new LocaleProvider(){

            public Locale get() {
                Locale locale = null;
                StaplerRequest req = Stapler.getCurrentRequest();
                if (req != null) {
                    locale = req.getLocale();
                }
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                return locale;
            }
        });
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Home dir is configured by admin or app.")
    protected File getHomeDir() {
        String varName = this.getApplicationName().toUpperCase() + "_HOME";
        String sysProp = System.getProperty(varName);
        if (sysProp != null) {
            return new File(sysProp.trim());
        }
        String env = System.getenv(varName);
        if (env != null) {
            return new File(env.trim()).getAbsoluteFile();
        }
        return this.getDefaultHomeDir();
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Home dir is configured by admin or app.")
    protected File getDefaultHomeDir() {
        return new File(new File(System.getProperty("user.home")), "." + this.getApplicationName().toLowerCase());
    }

    public void contextDestroyed(ServletContextEvent event) {
        Object o = event.getServletContext().getAttribute(APP);
        if (this.rootType.isInstance(o)) {
            this.cleanUp(this.rootType.cast(o));
        }
    }

    protected void cleanUp(T app) {
    }
}

