/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.interceptor;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.Interceptor;
import org.kohsuke.stapler.interceptor.InterceptorAnnotation;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.FIELD})
@InterceptorAnnotation(value=Processor.class)
public @interface JsonOutputFilter {
    public String[] includes() default {};

    public String[] excludes() default {};

    public boolean ignoreTransient() default true;

    public boolean ignoreDefaultExcludes() default false;

    public static class FilterPropertyFilter
    implements PropertyFilter {
        private Set<String> includes;
        private Set<String> excludes;

        FilterPropertyFilter(String[] includes, String[] excludes) {
            this(new HashSet<String>(Arrays.asList(includes)), new HashSet<String>(Arrays.asList(excludes)));
        }

        FilterPropertyFilter(Set<String> includes, Set<String> excludes) {
            this.includes = includes;
            this.excludes = excludes;
        }

        public boolean apply(Object source, String name, Object value) {
            if (this.excludes.contains(name)) {
                return true;
            }
            if (!this.includes.isEmpty()) {
                return !this.includes.contains(name);
            }
            return false;
        }
    }

    public static class Processor
    extends Interceptor {
        @Override
        public Object invoke(StaplerRequest request, StaplerResponse response, Object instance, Object[] arguments) throws IllegalAccessException, InvocationTargetException, ServletException {
            JsonOutputFilter annotation = this.target.getAnnotation(JsonOutputFilter.class);
            if (annotation != null) {
                JsonConfig config = new JsonConfig();
                config.setJsonPropertyFilter((PropertyFilter)new FilterPropertyFilter(annotation.includes(), annotation.excludes()));
                config.setIgnoreTransientFields(annotation.ignoreTransient());
                config.setIgnoreDefaultExcludes(annotation.ignoreDefaultExcludes());
                response.setJsonConfig(config);
            }
            return this.target.invoke(request, response, instance, arguments);
        }
    }
}

