/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.AbstractModelObject;
import hudson.model.Node;
import hudson.security.Permission;
import java.io.IOException;
import java.util.Set;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

@ExtensionPoint.LegacyInstancesAreScopedToHudson
public abstract class AdministrativeMonitor
extends AbstractModelObject
implements ExtensionPoint,
StaplerProxy {
    public final String id;

    protected AdministrativeMonitor(String id) {
        this.id = id;
    }

    protected AdministrativeMonitor() {
        this.id = this.getClass().getName();
    }

    public String getUrl() {
        return "administrativeMonitor/" + this.id;
    }

    @Override
    public String getDisplayName() {
        return this.id;
    }

    @Override
    public final String getSearchUrl() {
        return this.getUrl();
    }

    public void disable(boolean value) throws IOException {
        Jenkins jenkins = Jenkins.get();
        Set<String> set = jenkins.getDisabledAdministrativeMonitors();
        if (value) {
            set.add(this.id);
        } else {
            set.remove(this.id);
        }
        jenkins.setDisabledAdministrativeMonitors(set);
        ((Node)jenkins).save();
    }

    public boolean isEnabled() {
        return !Jenkins.get().getDisabledAdministrativeMonitors().contains(this.id);
    }

    public abstract boolean isActivated();

    public boolean isSecurity() {
        return false;
    }

    @RequirePOST
    public void doDisable(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        this.disable(true);
        rsp.sendRedirect2(req.getContextPath() + "/manage");
    }

    @Deprecated
    public Permission getRequiredPermission() {
        return Jenkins.ADMINISTER;
    }

    public void checkRequiredPermission() {
        Jenkins.get().checkPermission(this.getRequiredPermission());
    }

    public boolean hasRequiredPermission() {
        return Jenkins.get().hasPermission(this.getRequiredPermission());
    }

    public static boolean hasPermissionToDisplay() {
        return Jenkins.get().hasAnyPermission(Jenkins.SYSTEM_READ, Jenkins.MANAGE);
    }

    @Restricted(value={NoExternalUse.class})
    public Object getTarget() {
        this.checkRequiredPermission();
        return this;
    }

    public static ExtensionList<AdministrativeMonitor> all() {
        return ExtensionList.lookup(AdministrativeMonitor.class);
    }
}

