/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Executor;
import hudson.model.Run;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;

final class RunnerStack {
    private final Map<Executor, Stack<Run.RunExecution>> stack = new WeakHashMap<Executor, Stack<Run.RunExecution>>();
    static final RunnerStack INSTANCE = new RunnerStack();

    RunnerStack() {
    }

    synchronized void push(Run.RunExecution r) {
        Executor e = Executor.currentExecutor();
        Stack s = this.stack.computeIfAbsent(e, k -> new Stack());
        s.push(r);
    }

    synchronized void pop() {
        Executor e = Executor.currentExecutor();
        Stack<Run.RunExecution> s = this.stack.get(e);
        s.pop();
        if (s.isEmpty()) {
            this.stack.remove(e);
        }
    }

    @CheckForNull
    synchronized Run.RunExecution peek() {
        Stack<Run.RunExecution> s;
        Executor e = Executor.currentExecutor();
        if (e != null && (s = this.stack.get(e)) != null && !s.isEmpty()) {
            return s.peek();
        }
        return null;
    }
}

