/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.AllView;
import hudson.model.Messages;
import hudson.model.View;
import hudson.model.ViewGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.kohsuke.stapler.export.Exported;

public abstract class ViewGroupMixIn {
    private final ViewGroup owner;

    @NonNull
    protected abstract List<View> views();

    @CheckForNull
    protected abstract String primaryView();

    protected abstract void primaryView(String var1);

    protected ViewGroupMixIn(ViewGroup owner) {
        this.owner = owner;
    }

    public void addView(@NonNull View v) throws IOException {
        v.owner = this.owner;
        this.views().add(v);
        this.owner.save();
    }

    public boolean canDelete(@NonNull View view) {
        return !view.isDefault();
    }

    public synchronized void deleteView(@NonNull View view) throws IOException {
        if (this.views().size() <= 1) {
            throw new IllegalStateException("Cannot delete last view");
        }
        this.views().remove(view);
        this.owner.save();
    }

    @CheckForNull
    public View getView(@CheckForNull String name) {
        if (name == null) {
            return null;
        }
        List<View> views = this.views();
        for (View v : views) {
            if (!v.getViewName().equals(name)) continue;
            return v;
        }
        for (View v : views) {
            View nestedView;
            if (!(v instanceof ViewGroup) || (nestedView = ((ViewGroup)((Object)v)).getView(name)) == null) continue;
            return nestedView;
        }
        if (!name.equals(this.primaryView())) {
            View pv = this.getPrimaryView();
            if (pv instanceof ViewGroup) {
                return ((ViewGroup)((Object)pv)).getView(name);
            }
            if (pv instanceof AllView && "all".equals(pv.name)) {
                for (Locale l : Locale.getAvailableLocales()) {
                    if (!name.equals(Messages._Hudson_ViewName().toString(l))) continue;
                    return pv;
                }
            }
        }
        return null;
    }

    @Exported
    public Collection<View> getViews() {
        List<View> orig = this.views();
        ArrayList<View> copy = new ArrayList<View>(orig.size());
        for (View v : orig) {
            if (!v.hasPermission(View.READ)) continue;
            copy.add(v);
        }
        copy.sort(View.SORTER);
        return copy;
    }

    @Exported
    @CheckForNull
    public View getPrimaryView() {
        View v = this.getView(this.primaryView());
        if (v == null && !this.views().isEmpty()) {
            v = this.views().get(0);
        }
        return v;
    }

    public void onViewRenamed(View view, String oldName, String newName) {
        if (oldName.equals(this.primaryView())) {
            this.primaryView(newName);
        }
    }
}

