/*
 * Decompiled with CFR 0.152.
 */
package hudson.widgets;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Functions;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.Queue;
import hudson.util.AlternativeUiTextProvider;
import hudson.widgets.Messages;
import hudson.widgets.Widget;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jenkins.model.HistoricalBuild;
import jenkins.util.SystemProperties;
import jenkins.widgets.HistoryPageEntry;
import jenkins.widgets.HistoryPageFilter;
import jenkins.widgets.WidgetFactory;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.Header;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class HistoryWidget<O extends ModelObject, T>
extends Widget {
    public static final AlternativeUiTextProvider.Message<HistoryWidget<?, ?>> DISPLAY_NAME = new AlternativeUiTextProvider.Message();
    public Iterable<T> baseList;
    private String nextBuildNumberToFetch;
    public final String baseUrl;
    public final O owner;
    private boolean trimmed;
    public final Adapter<? super T> adapter;
    final Long newerThan;
    final Long olderThan;
    final String searchString;
    private String firstTransientBuildKey;
    static final int THRESHOLD = SystemProperties.getInteger(HistoryWidget.class.getName() + ".threshold", 30);

    public HistoryWidget(O owner, Iterable<T> baseList, Adapter<? super T> adapter) {
        StaplerRequest2 currentRequest = Stapler.getCurrentRequest2();
        this.adapter = adapter;
        this.baseList = baseList;
        this.baseUrl = Functions.getNearestAncestorUrl(currentRequest, owner);
        this.owner = owner;
        this.newerThan = this.getPagingParam(currentRequest, "newer-than");
        this.olderThan = this.getPagingParam(currentRequest, "older-than");
        this.searchString = currentRequest.getParameter("search");
    }

    @Override
    protected String getOwnerUrl() {
        return this.baseUrl;
    }

    public String getDisplayName() {
        return AlternativeUiTextProvider.get(DISPLAY_NAME, this, Messages.BuildHistoryWidget_DisplayName());
    }

    @Override
    public String getUrlName() {
        return "buildHistory";
    }

    public String getFirstTransientBuildKey() {
        return this.firstTransientBuildKey;
    }

    protected HistoryPageFilter updateFirstTransientBuildKey(HistoryPageFilter historyPageFilter) {
        this.updateFirstTransientBuildKey(historyPageFilter.runs);
        return historyPageFilter;
    }

    private Iterable<HistoryPageEntry<T>> updateFirstTransientBuildKey(Iterable<HistoryPageEntry<T>> source) {
        String key = null;
        for (HistoryPageEntry<T> t : source) {
            if (!this.adapter.isBuilding(t.getEntry())) continue;
            key = this.adapter.getKey(t.getEntry());
        }
        this.firstTransientBuildKey = key;
        return source;
    }

    public Iterable<HistoryPageEntry<T>> getRenderList() {
        if (this.trimmed) {
            List<HistoryPageEntry<T>> pageEntries = this.toPageEntries(this.baseList);
            if (pageEntries.size() > THRESHOLD) {
                return this.updateFirstTransientBuildKey(pageEntries.subList(0, THRESHOLD));
            }
            this.trimmed = false;
            return this.updateFirstTransientBuildKey(pageEntries);
        }
        return this.updateFirstTransientBuildKey(this.toPageEntries(this.baseList));
    }

    private List<HistoryPageEntry<T>> toPageEntries(Iterable<T> historyItemList) {
        Iterator<T> iterator = historyItemList.iterator();
        if (!iterator.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<HistoryPageEntry<T>> pageEntries = new ArrayList<HistoryPageEntry<T>>();
        while (iterator.hasNext()) {
            pageEntries.add(new HistoryPageEntry<T>(iterator.next()));
        }
        return pageEntries;
    }

    public HistoryPageFilter<T> getHistoryPageFilter() {
        HistoryPageFilter<T> historyPageFilter = this.newPageFilter();
        historyPageFilter.add(this.baseList);
        historyPageFilter.widget = this;
        return this.updateFirstTransientBuildKey(historyPageFilter);
    }

    protected HistoryPageFilter<T> newPageFilter() {
        HistoryPageFilter historyPageFilter = new HistoryPageFilter(THRESHOLD);
        historyPageFilter.widget = this;
        if (this.newerThan != null) {
            historyPageFilter.setNewerThan(this.newerThan);
        } else if (this.olderThan != null) {
            historyPageFilter.setOlderThan(this.olderThan);
        }
        if (this.searchString != null) {
            historyPageFilter.setSearchString(this.searchString);
        }
        return historyPageFilter;
    }

    public boolean isTrimmed() {
        return this.trimmed;
    }

    public void setTrimmed(boolean trimmed) {
        this.trimmed = trimmed;
    }

    public void doAjax(StaplerRequest2 req, StaplerResponse2 rsp, @Header(value="n") String n) throws IOException, ServletException {
        rsp.setContentType("text/html;charset=UTF-8");
        ArrayList<T> items = new ArrayList<T>();
        if (n != null) {
            String nn = null;
            for (T t : this.baseList) {
                if (this.adapter.compare(t, n) < 0) break;
                items.add(t);
                if (!this.adapter.isBuilding(t)) continue;
                nn = this.adapter.getKey(t);
            }
            if (nn == null) {
                nn = items.isEmpty() ? n : this.adapter.getNextKey(this.adapter.getKey(items.get(0)));
            }
            this.baseList = items;
            rsp.setHeader("n", nn);
            this.firstTransientBuildKey = nn;
        }
        HistoryPageFilter<T> page = this.getHistoryPageFilter();
        req.getView(page, "ajaxBuildHistory.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public String getNextBuildNumberToFetch() {
        return this.nextBuildNumberToFetch;
    }

    public void setNextBuildNumberToFetch(String nextBuildNumberToFetch) {
        this.nextBuildNumberToFetch = nextBuildNumberToFetch;
    }

    private Long getPagingParam(@CheckForNull StaplerRequest2 currentRequest, @CheckForNull String name) {
        if (currentRequest == null || name == null) {
            return null;
        }
        String paramVal = currentRequest.getParameter(name);
        if (paramVal == null) {
            return null;
        }
        try {
            return Long.valueOf(paramVal);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static interface Adapter<T> {
        public int compare(T var1, String var2);

        public String getKey(T var1);

        public boolean isBuilding(T var1);

        public String getNextKey(String var1);
    }

    @Extension
    @Restricted(value={DoNotUse.class})
    @Symbol(value={"history"})
    public static final class FactoryImpl
    extends WidgetFactory<Job, HistoryWidget> {
        @Override
        public Class<Job> type() {
            return Job.class;
        }

        @Override
        public Class<HistoryWidget> widgetType() {
            return HistoryWidget.class;
        }

        @Override
        @NonNull
        public Collection<HistoryWidget> createFor(@NonNull Job target) {
            if (!(target instanceof Queue.Task)) {
                return List.of(new HistoryWidget<Job, HistoricalBuild>(target, target.getBuilds(), Job.HISTORY_ADAPTER));
            }
            return Collections.emptySet();
        }
    }
}

