/*
 * Decompiled with CFR 0.152.
 */
package jenkins.console;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.BulkChange;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.appearance.AppearanceCategory;
import jenkins.console.ConsoleUrlProvider;
import jenkins.console.DefaultConsoleUrlProvider;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
@Symbol(value={"consoleUrlProvider"})
@Restricted(value={NoExternalUse.class})
public class ConsoleUrlProviderGlobalConfiguration
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(ConsoleUrlProviderGlobalConfiguration.class.getName());
    private List<ConsoleUrlProvider> providers;

    public ConsoleUrlProviderGlobalConfiguration() {
        this.load();
    }

    @Override
    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(AppearanceCategory.class);
    }

    public List<ConsoleUrlProvider> getProviders() {
        return this.providers;
    }

    @DataBoundSetter
    public void setProviders(List<ConsoleUrlProvider> providers) {
        this.providers = providers;
        this.save();
    }

    @Override
    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        try (BulkChange bc = new BulkChange(this);){
            this.providers = null;
            req.bindJSON((Object)this, json);
            bc.commit();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to save " + this.getConfigFile(), e);
        }
        return true;
    }

    public boolean isEnabled() {
        return ConsoleUrlProvider.isEnabled();
    }

    public static ConsoleUrlProviderGlobalConfiguration get() {
        return ExtensionList.lookupSingleton(ConsoleUrlProviderGlobalConfiguration.class);
    }

    public List<? extends Descriptor<ConsoleUrlProvider>> getProvidersDescriptors() {
        return Jenkins.get().getDescriptorList(ConsoleUrlProvider.class).stream().filter(d -> !(d instanceof DefaultConsoleUrlProvider.DescriptorImpl)).collect(Collectors.toList());
    }
}

