/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.queue;

import hudson.model.TaskListener;
import hudson.model.queue.CauseOfBlockage;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class CompositeCauseOfBlockage
extends CauseOfBlockage {
    public final Map<String, CauseOfBlockage> uniqueReasons = new TreeMap<String, CauseOfBlockage>();

    public CompositeCauseOfBlockage(List<CauseOfBlockage> delegates) {
        for (CauseOfBlockage delegate : delegates) {
            this.uniqueReasons.put(delegate.getShortDescription(), delegate);
        }
    }

    @Override
    public String getShortDescription() {
        return String.join((CharSequence)"; ", this.uniqueReasons.keySet());
    }

    @Override
    public void print(TaskListener listener) {
        for (CauseOfBlockage delegate : this.uniqueReasons.values()) {
            delegate.print(listener);
        }
    }
}

