/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class ReflectionUtils {
    private static final Map<Class, Object> defaultPrimitiveValue = new HashMap<Class, Object>();

    public static Object getVmDefaultValueFor(Class<?> type) {
        return defaultPrimitiveValue.get(type);
    }

    public static Annotation[] union(Annotation[] a, Annotation[] b) {
        if (a.length == 0) {
            return b;
        }
        if (b.length == 0) {
            return a;
        }
        ArrayList<Annotation> combined = new ArrayList<Annotation>(a.length + b.length);
        combined.addAll(Arrays.asList(a));
        block0: for (Annotation x : b) {
            for (int i = 0; i < a.length; ++i) {
                if (x.annotationType() != ((Annotation)combined.get(i)).annotationType()) continue;
                combined.set(i, x);
                continue block0;
            }
            combined.add(x);
        }
        return combined.toArray(new Annotation[0]);
    }

    public static boolean isOverridden(@NonNull Class<?> base, @NonNull Class<?> derived, @NonNull String methodName, Class<?> ... types) {
        if (!base.isAssignableFrom(derived)) {
            throw new IllegalArgumentException("The specified derived class (" + derived.getCanonicalName() + ") does not derive from the specified base class (" + base.getCanonicalName() + ").");
        }
        Method baseMethod = ReflectionUtils.getMethod(base, null, methodName, types);
        if (baseMethod == null) {
            throw new IllegalArgumentException("The specified method is not declared by the specified base class (" + base.getCanonicalName() + "), or it is private, static or final.");
        }
        Method derivedMethod = ReflectionUtils.getMethod(derived, base, methodName, types);
        return derivedMethod != null && derivedMethod != baseMethod;
    }

    public static <T> T ifOverridden(Supplier<T> supplier, @NonNull Class<?> base, @NonNull Class<?> derived, @NonNull String methodName, Class<?> ... types) {
        if (ReflectionUtils.isOverridden(base, derived, methodName, types)) {
            return supplier.get();
        }
        throw new AbstractMethodError("The class " + derived.getName() + " must override at least one of the " + base.getSimpleName() + "." + methodName + " methods");
    }

    private static Method getMethod(@NonNull Class<?> clazz, @Nullable Class<?> base, @NonNull String methodName, Class<?> ... types) {
        try {
            Method res = clazz.getDeclaredMethod(methodName, types);
            int mod = res.getModifiers();
            if (Modifier.isPrivate(mod) || Modifier.isStatic(mod)) {
                return null;
            }
            if (base == null && Modifier.isFinal(mod)) {
                return null;
            }
            if (base != null && Modifier.isAbstract(mod)) {
                return null;
            }
            return res;
        }
        catch (NoSuchMethodException e) {
            Class<?> superclass;
            if (base != null && Modifier.isInterface(base.getModifiers())) {
                for (Class<?> iface : clazz.getInterfaces()) {
                    Method defaultImpl;
                    if (base.equals(iface) || !base.isAssignableFrom(iface) || (defaultImpl = ReflectionUtils.getMethod(iface, base, methodName, types)) == null) continue;
                    return defaultImpl;
                }
            }
            if ((superclass = clazz.getSuperclass()) != null) {
                if (base != null && (base.equals(superclass) || !base.isAssignableFrom(superclass))) {
                    return null;
                }
                return ReflectionUtils.getMethod(superclass, base, methodName, types);
            }
            return null;
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        defaultPrimitiveValue.put(Boolean.TYPE, false);
        defaultPrimitiveValue.put(Integer.TYPE, 0);
        defaultPrimitiveValue.put(Long.TYPE, 0L);
    }
}

