/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.AbstractTearOff;
import org.kohsuke.stapler.DispatchValidator;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.ScriptExecutor;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

class ScriptRequestDispatcher<S>
implements RequestDispatcher {
    private static final Logger LOGGER = Logger.getLogger(ScriptRequestDispatcher.class.getName());
    @NonNull
    private final String defaultScriptExtension;
    @NonNull
    private final ScriptExecutor<? super S> scriptExecutor;
    @NonNull
    private final String viewName;
    @NonNull
    private final S script;
    @CheckForNull
    private final Object node;

    @CheckForNull
    static <S> ScriptRequestDispatcher<S> newRequestDispatcher(@NonNull AbstractTearOff<?, ? extends S, ?> scriptLoader, @NonNull ScriptExecutor<? super S> scriptExecutor, @NonNull String viewName, @CheckForNull Object node) {
        Object script;
        try {
            script = scriptLoader.findScript(viewName);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e, () -> "Could not load requested view " + viewName + " on model class " + (node == null ? null : node.getClass().getName()));
            return null;
        }
        if (script == null) {
            return null;
        }
        return new ScriptRequestDispatcher<S>(scriptLoader.getDefaultScriptExtension(), scriptExecutor, viewName, script, node);
    }

    private ScriptRequestDispatcher(@NonNull String defaultScriptExtension, @NonNull ScriptExecutor<? super S> scriptExecutor, @NonNull String viewName, @NonNull S script, @CheckForNull Object node) {
        this.defaultScriptExtension = defaultScriptExtension;
        this.scriptExecutor = scriptExecutor;
        this.viewName = viewName;
        this.script = script;
        this.node = node;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        StaplerRequest2 req = (StaplerRequest2)request;
        StaplerResponse2 rsp = (StaplerResponse2)response;
        DispatchValidator validator = req.getWebApp().getDispatchValidator();
        validator.allowDispatch(req, rsp);
        try {
            Dispatcher.anonymizedTraceEval(req, rsp, this.node, "%s: View: %s%s", this.viewName, this.defaultScriptExtension);
            if (Dispatcher.traceable()) {
                Dispatcher.trace(req, rsp, "-> %s on <%s>", this.viewName, this.node);
            }
            this.scriptExecutor.execute(req, rsp, this.script, this.node);
        }
        catch (ServletException | IOException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    @SuppressFBWarnings(value={"REQUESTDISPATCHER_FILE_DISCLOSURE"}, justification="Forwarding the request to be handled correctly.")
    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.forward(request, response);
    }
}

