/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.bind;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public abstract class Bound
implements HttpResponse {
    public abstract void release();

    public abstract String getURL();

    public abstract Object getTarget();

    public final String getProxyScript() {
        return Bound.getProxyScript(this.getURL(), this.getTarget().getClass());
    }

    public static String getProxyScriptURL(String variableName, Bound bound) {
        if (bound == null) {
            return Stapler.getCurrentRequest2().getContextPath() + "/$stapler/bound/script/null?var=" + variableName;
        }
        return bound.getProxyScriptURL(variableName);
    }

    public final String getProxyScriptURL(String variableName) {
        String methodsList = String.join((CharSequence)",", Bound.getBoundJavaScriptUrlNames(this.getTarget().getClass()));
        return Stapler.getCurrentRequest2().getContextPath() + "/$stapler/bound/script" + this.getURL() + "?var=" + variableName + "&methods=" + methodsList;
    }

    private static Set<String> getBoundJavaScriptUrlNames(Class<?> clazz) {
        HashSet<String> names = new HashSet<String>();
        for (Method m : clazz.getMethods()) {
            if (m.getName().startsWith("js")) {
                names.add(Bound.camelize(m.getName().substring(2)));
                continue;
            }
            JavaScriptMethod a = m.getAnnotation(JavaScriptMethod.class);
            if (a == null) continue;
            if (a.name().length == 0) {
                names.add(m.getName());
                continue;
            }
            names.addAll(Arrays.asList(a.name()));
        }
        return names;
    }

    public final Set<String> getBoundJavaScriptUrlNames() {
        return Bound.getBoundJavaScriptUrlNames(this.getTarget().getClass());
    }

    public static String getProxyScript(String url, Class<?> clazz) {
        return Bound.getProxyScript(url, (String[])Bound.getBoundJavaScriptUrlNames(clazz).toArray(String[]::new));
    }

    public static String getProxyScript(String url, String[] methods) {
        String crumb = WebApp.getCurrent().getCrumbIssuer().issueCrumb();
        String methodNamesList = Arrays.stream(methods).sorted().map(it -> "'" + it + "'").collect(Collectors.joining(","));
        return "makeStaplerProxy('" + url + "','" + crumb + "',[" + methodNamesList + "])";
    }

    private static String camelize(String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }
}

